/*
 * $Id: ExternalTransactionAwareTransactionFactory.java 19191 2010-08-25 21:05:23Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.transaction;

import org.mule.api.MuleContext;


/**
 * <code>ExternalTransactionAwareTransactionFactory</code> creates a transaction, possibly representing a transaction
 * started outside Mule.
 *
 */
public interface ExternalTransactionAwareTransactionFactory extends TransactionFactory
{
    /**
     * Create and begins a new transaction
     *
     * @return a new Transaction representing an existing external transaction
     * @throws org.mule.api.transaction.TransactionException if the transaction cannot be created or begun
     * @param muleContext
     */
    Transaction joinExternalTransaction(MuleContext muleContext) throws TransactionException;
}
