/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class ListMessageSplitterTestCase
extends AbstractMuleContextTestCase {
    public ListMessageSplitterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testCorrelationGroupSizePropertySet() throws Exception {
        Service testService = ListMessageSplitterTestCase.getTestService("test", Apple.class);
        MuleSession session = ListMessageSplitterTestCase.getTestSession(testService, muleContext);
        OutboundEndpoint endpoint = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpoint?exchangePattern=request-response");
        ListMessageSplitter router = new ListMessageSplitter();
        router.setFilter(null);
        router.addRoute((MessageProcessor)endpoint);
        router.setMuleContext(muleContext);
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("one");
        payload.add("two");
        payload.add("three");
        payload.add("four");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((String)"There should be 4 results for 4 split messages.", (long)4L, (long)((MuleMessageCollection)resultMessage).size());
    }

    @Test
    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)ListMessageSplitterTestCase.getTestService());
        session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint2 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint3 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        Mock mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        OutboundEndpoint endpoint4 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test4endpoint", "test://endpointUri.4?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint5 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?exchangePattern=request-response", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint6 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?exchangePattern=request-response");
        Mock mockendpoint4 = RouterTestUtils.getMockEndpoint(endpoint4);
        Mock mockendpoint5 = RouterTestUtils.getMockEndpoint(endpoint5);
        Mock mockendpoint6 = RouterTestUtils.getMockEndpoint(endpoint6);
        ListMessageSplitter asyncSplitter = new ListMessageSplitter();
        asyncSplitter.setMuleContext(muleContext);
        asyncSplitter.setDisableRoundRobin(true);
        asyncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        asyncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        asyncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        asyncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint3.proxy()));
        ListMessageSplitter syncSplitter = new ListMessageSplitter();
        syncSplitter.setMuleContext(muleContext);
        syncSplitter.setDisableRoundRobin(true);
        syncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        syncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint4.proxy()));
        syncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint5.proxy()));
        syncSplitter.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint6.proxy()));
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(new Apple());
        payload.add(new Apple());
        payload.add(new Orange());
        payload.add("");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        Assert.assertTrue((boolean)asyncSplitter.isMatch((MuleMessage)message));
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint3.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        asyncSplitter.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        session.verify();
        message = new DefaultMuleMessage(payload, muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        mockendpoint4.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint4.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint5.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint6.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = syncSplitter.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((long)4L, (long)((MuleMessageCollection)resultMessage).size());
        session.verify();
    }
}

