/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;

public class TransactionCoordinationTestCase
extends AbstractMuleTestCase {
    private TransactionCoordination tc;

    @Before
    public void setUpTransaction() throws Exception {
        this.tc = TransactionCoordination.getInstance();
    }

    @After
    public void unbindTransaction() throws Exception {
        this.tc.unbindTransaction(this.tc.getTransaction());
    }

    @Test
    public void testBindTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testBindTransactionWithAlreadyBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        Assert.assertEquals((Object)tx, (Object)this.tc.getTransaction());
        try {
            Transaction tx2 = (Transaction)Mockito.mock(Transaction.class);
            this.tc.bindTransaction(tx2);
            Assert.fail();
        }
        catch (IllegalTransactionStateException illegalTransactionStateException) {
            // empty catch block
        }
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testUnbindTransactionWithoutBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testSetInstanceWithBound() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        this.tc.unbindTransaction(tx);
    }

    @Test
    public void testCommitCurrentTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.commitCurrentTransaction();
        TestTransaction testTransaction = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        this.tc.bindTransaction((Transaction)testTransaction);
        this.tc.commitCurrentTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)testTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).commit();
    }

    @Test
    public void testCommitCurrentTransactionWithSuspendedTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction xaTx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        xaTx.setXA(true);
        Transaction tx = (Transaction)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class))));
        this.tc.bindTransaction((Transaction)xaTx);
        this.tc.suspendCurrentTransaction();
        this.tc.bindTransaction(tx);
        this.tc.commitCurrentTransaction();
        this.tc.resumeSuspendedTransaction();
        Assert.assertThat((Object)((Object)((TestTransaction)this.tc.getTransaction())), (Matcher)Is.is((Object)((Object)xaTx)));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)xaTx), (VerificationMode)VerificationModeFactory.times((int)1)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)xaTx), (VerificationMode)VerificationModeFactory.times((int)1)))).resume();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).commit();
    }

    @Test
    public void testCommitDoesntFailOnException() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doThrow((Throwable)new TransactionException((Throwable)null)).when((Object)tx)).commit();
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    @Test
    public void testRollbackCurrentTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.commitCurrentTransaction();
        TestTransaction testTransaction = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        this.tc.bindTransaction((Transaction)testTransaction);
        this.tc.rollbackCurrentTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)testTransaction), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
    }

    @Test
    public void testRollbackCurrentTransactionWithSuspendedTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction xaTx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        xaTx.setXA(true);
        Transaction tx = (Transaction)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class))));
        this.tc.bindTransaction((Transaction)xaTx);
        this.tc.suspendCurrentTransaction();
        this.tc.bindTransaction(tx);
        this.tc.rollbackCurrentTransaction();
        this.tc.resumeSuspendedTransaction();
        Assert.assertThat((Object)((Object)((TestTransaction)this.tc.getTransaction())), (Matcher)Is.is((Object)((Object)xaTx)));
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)xaTx), (VerificationMode)VerificationModeFactory.times((int)1)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)xaTx), (VerificationMode)VerificationModeFactory.times((int)1)))).resume();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).rollback();
    }

    @Test
    public void testRollbackDoesntFailOnException() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doThrow((Throwable)new TransactionException((Throwable)null)).when((Object)tx)).rollback();
        TransactionCoordination.getInstance().rollbackCurrentTransaction();
    }

    @Test
    public void testSuspendResumeTransaction() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        this.tc.bindTransaction(tx);
        this.tc.suspendCurrentTransaction();
        Assert.assertNull((Object)this.tc.getTransaction());
        this.tc.resumeSuspendedTransaction();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).suspend();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)1))).resume();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)Is.is((Object)tx));
    }

    @Test
    public void testResumeXaTransactionIfAvailableWithNoTx() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.resumeXaTransactionIfAvailable();
        Transaction tx = (Transaction)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class))));
        this.tc.bindTransaction(tx);
        this.tc.resumeXaTransactionIfAvailable();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)VerificationModeFactory.times((int)0))).resume();
    }

    @Test
    public void testResumeXaTransactionIfAvailableWithTx() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        this.tc.resumeXaTransactionIfAvailable();
        TestTransaction tx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.suspendCurrentTransaction();
        this.tc.resumeXaTransactionIfAvailable();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)tx), (VerificationMode)VerificationModeFactory.times((int)1)))).suspend();
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)tx), (VerificationMode)VerificationModeFactory.times((int)1)))).resume();
    }

    @Test(expected=IllegalTransactionStateException.class)
    public void testResumeXaTransactionTwice() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.resumeSuspendedTransaction();
        this.tc.resumeSuspendedTransaction();
    }

    @Test
    public void testResolveTransactionForRollback() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        tx.setRollbackOnly();
        this.tc.resolveTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)tx), (VerificationMode)VerificationModeFactory.times((int)1)))).rollback();
    }

    @Test
    public void testResolveTransactionForCommit() throws Exception {
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        TestTransaction tx = (TestTransaction)((Object)Mockito.spy((Object)((Object)new TestTransaction((MuleContext)Mockito.mock(MuleContext.class)))));
        tx.setXA(true);
        this.tc.bindTransaction((Transaction)tx);
        this.tc.resolveTransaction();
        Assert.assertThat((Object)this.tc.getTransaction(), (Matcher)IsNull.nullValue());
        ((TestTransaction)((Object)Mockito.verify((Object)((Object)tx), (VerificationMode)VerificationModeFactory.times((int)1)))).commit();
    }
}

