/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.simple.AbstractRemoveVariablePropertyTransformer;
import org.mule.transformer.simple.RemoveFlowVariableTransformer;
import org.mule.transformer.simple.RemovePropertyTransformer;
import org.mule.transformer.simple.RemoveSessionVariableTransformer;

@RunWith(value=Parameterized.class)
@SmallTest
public class RemoveVariablePropertyTransformerTest
extends AbstractMuleTestCase {
    public static final String ENCODING = "encoding";
    public static final String PLAIN_STRING_KEY = "someText";
    public static final String PLAIN_STRING_VALUE = "someValue";
    public static final String EXPRESSION = "#[string:someValue]";
    public static final String EXPRESSION_VALUE = "expressionValueResult";
    public static final String NULL_EXPRESSION = "#[string:someValueNull]";
    public static final String NULL_EXPRESSION_VALUE = null;
    private MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExpressionManager mockExpressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private AbstractRemoveVariablePropertyTransformer removeVariableTransformer;
    private PropertyScope scope;

    public RemoveVariablePropertyTransformerTest(AbstractRemoveVariablePropertyTransformer abstractAddVariableTransformer, PropertyScope scope) {
        this.removeVariableTransformer = abstractAddVariableTransformer;
        this.scope = scope;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new RemoveFlowVariableTransformer(), PropertyScope.INVOCATION}, {new RemoveSessionVariableTransformer(), PropertyScope.SESSION}, {new RemovePropertyTransformer(), PropertyScope.OUTBOUND});
    }

    @Before
    public void setUpTest() {
        Mockito.when((Object)this.mockMuleContext.getExpressionManager()).thenReturn((Object)this.mockExpressionManager);
        Mockito.when((Object)this.mockExpressionManager.parse(Matchers.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        Mockito.when((Object)this.mockExpressionManager.evaluate(EXPRESSION, this.mockMessage)).thenReturn((Object)EXPRESSION_VALUE);
        this.removeVariableTransformer.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void testRemoveVariable() throws InitialisationException, TransformerException {
        this.removeVariableTransformer.setIdentifier(PLAIN_STRING_KEY);
        this.removeVariableTransformer.initialise();
        this.removeVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).removeProperty(PLAIN_STRING_KEY, this.scope);
    }

    @Test
    public void testRemoveVariableUsingExpression() throws InitialisationException, TransformerException {
        this.removeVariableTransformer.setIdentifier(EXPRESSION);
        this.removeVariableTransformer.initialise();
        this.removeVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).removeProperty(EXPRESSION_VALUE, this.scope);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveVariableNullKey() throws InitialisationException, TransformerException {
        this.removeVariableTransformer.setIdentifier(null);
    }

    @Test
    public void testRemoveVariableExpressionKeyNullValue() throws InitialisationException, TransformerException {
        this.removeVariableTransformer.setIdentifier(NULL_EXPRESSION);
        this.removeVariableTransformer.initialise();
        this.removeVariableTransformer.transform((Object)this.mockMessage, ENCODING);
    }

    @Test
    @Ignore
    public void testRemoveVariableWithRegexExpression() throws InitialisationException, TransformerException {
        Mockito.when((Object)this.mockMessage.getPropertyNames(this.scope)).thenReturn(new HashSet<String>(Arrays.asList("MULE_ID", "MULE_CORRELATION_ID", "SomeVar", "MULE_GROUP_ID")));
        this.removeVariableTransformer.setIdentifier("MULE_(.*)");
        this.removeVariableTransformer.initialise();
        this.removeVariableTransformer.transform((Object)this.mockMessage, ENCODING);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).removeProperty("MULE_ID", this.scope);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).removeProperty("MULE_CORRELATION_ID", this.scope);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage)).removeProperty("MULE_GROUP_ID", this.scope);
        ((MuleMessage)Mockito.verify((Object)this.mockMessage, (VerificationMode)VerificationModeFactory.times((int)0))).removeProperty("SomeVar", this.scope);
    }
}

