/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSDerivedKeyTokenPrincipal;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSamlPolicyValidator
extends AbstractTokenPolicyValidator {
    @Override
    protected boolean isTokenRequired(Token token, Message message) {
        SPConstants.IncludeTokenType inclusion = token.getInclusion();
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            return false;
        }
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS) {
            return true;
        }
        boolean initiator = MessageUtils.isRequestor((Message)message);
        if (initiator && inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR) {
            return true;
        }
        return !initiator && (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT);
    }

    public boolean checkHolderOfKey(AssertionWrapper assertionWrapper, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod)) continue;
            if (tlsCerts == null && (signedResults == null || signedResults.isEmpty())) {
                return false;
            }
            SAMLKeyInfo subjectKeyInfo = assertionWrapper.getSubjectKeyInfo();
            if (this.compareCredentials(subjectKeyInfo, signedResults, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, List<WSSecurityEngineResult> signedResults, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        byte[] subjectSecretKey = subjectKeyInfo.getSecret();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        for (WSSecurityEngineResult signedResult : signedResults) {
            X509Certificate[] certs = (X509Certificate[])signedResult.get((Object)"x509-certificates");
            PublicKey publicKey = (PublicKey)signedResult.get((Object)"public-key");
            byte[] secretKey = (byte[])signedResult.get((Object)"secret");
            if (certs != null && certs.length > 0 && subjectCerts != null && subjectCerts.length > 0 && certs[0].equals(subjectCerts[0])) {
                return true;
            }
            if (publicKey != null && publicKey.equals(subjectPublicKey)) {
                return true;
            }
            if (!this.checkSecretKey(secretKey, subjectSecretKey, signedResult)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSecretKey(byte[] secretKey, byte[] subjectSecretKey, WSSecurityEngineResult signedResult) {
        if (secretKey != null && subjectSecretKey != null) {
            if (Arrays.equals(secretKey, subjectSecretKey)) {
                return true;
            }
            Principal principal = (Principal)signedResult.get((Object)"principal");
            if (principal instanceof WSDerivedKeyTokenPrincipal && Arrays.equals(secretKey = ((WSDerivedKeyTokenPrincipal)principal).getSecret(), subjectSecretKey)) {
                return true;
            }
        }
        return false;
    }
}

