/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.work.AbstractMuleEventWork;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements MessageProcessor,
Initialisable,
Startable,
Stoppable {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected MessageProcessor delegate;
    protected List<MessageProcessor> processors;
    protected ProcessingStrategy processingStrategy;
    protected String name;
    private MessageProcessor target;

    public AsyncDelegateMessageProcessor(MessageProcessor delegate, ProcessingStrategy processingStrategy, String name) {
        this.delegate = delegate;
        this.processingStrategy = processingStrategy;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.delegate == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        if (this.processingStrategy == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("processingStrategy"), (Initialisable)this);
        }
        ProcessingStrategy.StageNameSource nameSource = null;
        nameSource = this.name != null ? ((Flow)this.flowConstruct).getAsyncStageNameSource(this.name) : ((Flow)this.flowConstruct).getAsyncStageNameSource();
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        this.processingStrategy.configureProcessors(Collections.singletonList(this.delegate), nameSource, builder, this.muleContext);
        try {
            this.target = builder.build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.initialise();
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event.isTransacted()) {
            throw new MessagingException(CoreMessages.asyncDoesNotSupportTransactions(), event, (MessageProcessor)this);
        }
        if (this.target != null) {
            DefaultMuleEvent newEvent = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)event.getMessage())).newThreadCopy()), event, false);
            this.target.process(newEvent);
        }
        if (this.muleContext.getConfiguration().isFlowEndingWithOneWayEndpointReturnsNull()) {
            return event;
        }
        return VoidMuleEvent.getInstance();
    }

    public void setDelegate(MessageProcessor delegate) {
        this.delegate = delegate;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.target);
    }

    public ProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
            try {
                AsyncDelegateMessageProcessor.this.delegate.process(this.event);
            }
            catch (MuleException e) {
                this.event.getFlowConstruct().getExceptionListener().handleException(e, this.event);
            }
        }
    }
}

