/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.expression.ExpressionConfig;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.CollectionSplitter;
import org.mule.routing.ExpressionSplitter;
import org.mule.routing.MapSplitter;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.routing.outbound.CollectionMessageSequence;
import org.mule.transformer.types.DataTypeFactory;
import org.w3c.dom.Document;

public class Foreach
extends AbstractMessageProcessorOwner
implements Initialisable,
InterceptingMessageProcessor {
    public static final String ROOT_MESSAGE_PROPERTY = "rootMessage";
    public static final String COUNTER_PROPERTY = "counter";
    private static final String XPATH_PREFIX = "xpath";
    protected Log logger = LogFactory.getLog(this.getClass());
    private List<MessageProcessor> messageProcessors;
    private MessageProcessor ownedMessageProcessor;
    private AbstractMessageSequenceSplitter splitter;
    private MessageProcessor next;
    private String collectionExpression;
    private ExpressionConfig expressionConfig = new ExpressionConfig();
    private int batchSize;
    private String rootMessageVariableName;
    private String counterVariableName;
    private boolean xpathCollection;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        String parentMessageProp = this.rootMessageVariableName != null ? this.rootMessageVariableName : ROOT_MESSAGE_PROPERTY;
        Object previousCounterVar = null;
        Object previousRootMessageVar = null;
        if (event.getFlowVariableNames().contains(this.counterVariableName)) {
            previousCounterVar = event.getFlowVariable(this.counterVariableName);
        }
        if (event.getFlowVariableNames().contains(parentMessageProp)) {
            previousRootMessageVar = event.getFlowVariable(parentMessageProp);
        }
        MuleMessage message = event.getMessage();
        boolean transformed = false;
        if (this.xpathCollection) {
            transformed = this.transformPayloadIfNeeded(message);
        }
        message.setInvocationProperty(parentMessageProp, message);
        this.ownedMessageProcessor.process(event);
        if (transformed) {
            this.transformBack(message);
        }
        if (previousCounterVar != null) {
            event.setFlowVariable(this.counterVariableName, previousCounterVar);
        } else {
            event.removeFlowVariable(this.counterVariableName);
        }
        if (previousRootMessageVar != null) {
            event.setFlowVariable(parentMessageProp, previousRootMessageVar);
        } else {
            event.removeFlowVariable(parentMessageProp);
        }
        return this.processNext(event);
    }

    private boolean transformPayloadIfNeeded(MuleMessage message) throws TransformerException {
        Object payload = message.getPayload();
        if (payload instanceof Document || "org.dom4j.Document".equals(payload.getClass().getName())) {
            return false;
        }
        message.setPayload(message.getPayload(DataTypeFactory.create(Document.class)));
        return true;
    }

    private void transformBack(MuleMessage message) throws TransformerException {
        message.setPayload(message.getPayload(DataType.STRING_DATA_TYPE));
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        return this.next.process(event);
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.next = listener;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.collectionExpression != null) {
            this.expressionConfig.setExpression(this.collectionExpression);
            this.checkEvaluator(this.expressionConfig);
            this.splitter = new ExpressionSplitter(this.expressionConfig);
            if (this.expressionConfig.getEvaluator() != null && this.expressionConfig.getEvaluator().startsWith(XPATH_PREFIX)) {
                this.xpathCollection = true;
            } else if (this.expressionConfig.getEvaluator() == null && this.expressionConfig.getExpression().matches("^xpath\\(.+\\)$")) {
                this.xpathCollection = true;
            }
        } else {
            this.splitter = new CollectionMapSplitter();
        }
        this.splitter.setBatchSize(this.batchSize);
        this.splitter.setCounterVariableName(this.counterVariableName);
        this.splitter.setMuleContext(this.muleContext);
        this.messageProcessors.add(0, this.splitter);
        try {
            this.ownedMessageProcessor = new DefaultMessageProcessorChainBuilder().chain(this.messageProcessors).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        super.initialise();
    }

    private void checkEvaluator(ExpressionConfig expressionConfig) {
        if (expressionConfig.getEvaluator() != null && expressionConfig.getEvaluator().startsWith(XPATH_PREFIX)) {
            expressionConfig.setEvaluator("xpath-branch");
        }
    }

    public void setCollectionExpression(String expression) {
        this.collectionExpression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    private static class CollectionMapSplitter
    extends CollectionSplitter {
        private CollectionMapSplitter() {
        }

        @Override
        protected MessageSequence<?> splitMessageIntoSequence(MuleEvent event) {
            Object payload = event.getMessage().getPayload();
            if (payload instanceof Map) {
                LinkedList<DefaultMuleMessage> list = new LinkedList<DefaultMuleMessage>();
                Set set = ((Map)payload).entrySet();
                for (Map.Entry entry : set) {
                    DefaultMuleMessage splitMessage = new DefaultMuleMessage(entry.getValue(), this.muleContext);
                    splitMessage.setInvocationProperty(MapSplitter.MAP_ENTRY_KEY, entry.getKey());
                    list.add(splitMessage);
                }
                return new CollectionMessageSequence(list);
            }
            return super.splitMessageIntoSequence(event);
        }
    }
}

