/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon;

import de.odysseus.staxon.XMLStreamWriterScope;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractXMLStreamWriter<T>
implements XMLStreamWriter {
    private XMLStreamWriterScope<T> scope;
    private boolean startDocumentWritten;

    public AbstractXMLStreamWriter(T rootInfo) {
        this.scope = new XMLStreamWriterScope<T>("", rootInfo);
        this.startDocumentWritten = false;
    }

    protected XMLStreamWriterScope<T> getScope() {
        return this.scope;
    }

    protected abstract void writeStartElementTag(XMLStreamWriterScope<T> var1) throws XMLStreamException;

    protected abstract void writeStartElementTagEnd() throws XMLStreamException;

    protected abstract void writeEndElementTag() throws XMLStreamException;

    protected abstract void writeAttr(String var1, String var2) throws XMLStreamException;

    protected abstract void writeText(String var1, int var2) throws XMLStreamException;

    protected abstract void writePI(String var1, String var2) throws XMLStreamException;

    private void ensureStartTagClosed() throws XMLStreamException {
        if (!this.scope.isStartTagClosed()) {
            this.writeStartElementTagEnd();
            this.scope.setStartTagClosed(true);
            if (this.scope.isEmptyElement()) {
                this.scope = this.scope.getParent();
            }
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        if (this.scope.getNamespaceURI("") == null) {
            throw new XMLStreamException("Default namespace URI has not been set");
        }
        this.writeStartElement("", localName, false);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        String prefix = this.scope.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
        }
        this.writeStartElement(prefix, localName, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix must not be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        if (this.scope.getPrefix(namespaceURI) == null) {
            this.scope.setPrefix(prefix, namespaceURI);
        }
        this.writeStartElement(prefix, localName, false);
    }

    private void writeStartElement(String prefix, String localPart, boolean emptyElement) throws XMLStreamException {
        if (localPart == null) {
            throw new XMLStreamException("Local name must not be null");
        }
        this.ensureStartTagClosed();
        if (this.startDocumentWritten && this.scope.isRoot() && this.scope.getLastChild() != null) {
            throw new XMLStreamException("Multiple roots within document");
        }
        XMLStreamWriterScope<T> newScope = new XMLStreamWriterScope<T>(this.scope, prefix, localPart, emptyElement);
        this.writeStartElementTag(newScope);
        this.scope = newScope;
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.ensureStartTagClosed();
        if (this.scope.isRoot()) {
            throw new XMLStreamException("Cannot write end element in root scope");
        }
        this.writeEndElementTag();
        this.scope = this.scope.getParent();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        if (this.scope.getNamespaceURI("") == null) {
            throw new XMLStreamException("Default namespace URI has not been set");
        }
        this.writeStartElement("", localName, true);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        String prefix = this.scope.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
        }
        this.writeStartElement(prefix, localName, true);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (prefix == null) {
            throw new XMLStreamException("Prefix must not be null");
        }
        if (namespaceURI == null) {
            throw new XMLStreamException("Namespace URI must not be null");
        }
        if (this.scope.getPrefix(namespaceURI) == null) {
            this.scope.setPrefix(prefix, namespaceURI);
        }
        this.writeStartElement(prefix, localName, true);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, "", localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        String name;
        if (this.scope.isStartTagClosed()) {
            throw new XMLStreamException("Cannot write attribute: element has children or text");
        }
        if ("".equals(namespaceURI)) {
            if (prefix != null && !"".equals(prefix)) throw new XMLStreamException("Cannot write attribute without a namespace URI and prefix: " + prefix);
            name = localName;
        } else {
            if (prefix == null) {
                prefix = this.scope.getPrefix(namespaceURI);
                if ("".equals(prefix)) {
                    Iterator<String> prefixes = this.scope.getPrefixes(namespaceURI);
                    while (prefixes.hasNext() && "".equals(prefix)) {
                        prefix = prefixes.next();
                    }
                } else if (prefix == null) {
                    throw new XMLStreamException("Namespace URI has not been bound to a prefix: " + namespaceURI);
                }
            } else if (!"".equals(prefix)) {
                String boundNamespaceURI = this.scope.getNamespaceURI(prefix);
                if ("".equals(boundNamespaceURI)) {
                    this.getScope().setPrefix(prefix, namespaceURI);
                } else if (!namespaceURI.equals(boundNamespaceURI)) {
                    throw new XMLStreamException("Another namespace URI has been bound to the given prefix: " + prefix);
                }
            }
            if ("".equals(prefix)) {
                throw new XMLStreamException("Cannot write attribute without prefix for namespace URI: " + namespaceURI);
            }
            name = prefix + ':' + localName;
        }
        this.writeAttr(name, value);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeText(text, 4);
    }

    @Override
    public void writeCharacters(char[] text, int start, int length) throws XMLStreamException {
        this.writeCharacters(new String(text, start, length));
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeText(data, 12);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument("UTF-8", null);
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writeStartDocument(null, version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (this.startDocumentWritten || !this.scope.isRoot()) {
            throw new XMLStreamException("Cannot start document");
        }
        if (version == null) {
            version = "1.0";
        }
        if (encoding == null) {
            this.writePI("xml", String.format("version=\"%s\"", version, encoding));
        } else {
            this.writePI("xml", String.format("version=\"%s\" encoding=\"%s\"", version, encoding));
        }
        this.startDocumentWritten = true;
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        if (!this.scope.isRoot()) {
            this.ensureStartTagClosed();
            while (!this.scope.isRoot()) {
                this.writeEndElement();
            }
        }
        this.startDocumentWritten = false;
    }

    @Override
    public void close() throws XMLStreamException {
        this.ensureStartTagClosed();
        this.flush();
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.scope.isStartTagClosed()) {
            throw new XMLStreamException("Cannot write namespace: element has children or text");
        }
        if (prefix == null || "xmlns".equals(prefix)) {
            prefix = "";
        }
        if ("".equals(prefix)) {
            this.writeAttribute("xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns:" + prefix, namespaceURI);
        }
        this.setPrefix(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writeNamespace("", namespaceURI);
    }

    @Override
    public String getPrefix(String namespaceURI) throws XMLStreamException {
        return this.scope.getPrefix(namespaceURI);
    }

    @Override
    public void setPrefix(String prefix, String namespaceURI) throws XMLStreamException {
        this.scope.setPrefix(prefix, namespaceURI);
    }

    @Override
    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.setPrefix("", namespaceURI);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        if (!this.scope.isRoot()) {
            throw new XMLStreamException("This method may only be called once at the start of the document");
        }
        this.scope = new XMLStreamWriterScope<T>(context, this.scope.getInfo());
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.scope;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeText(data, 5);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writePI(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writePI(target, data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeText(dtd, 11);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.ensureStartTagClosed();
        this.writeText(name, 9);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unsupported property: " + name);
    }
}

