/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.udp.UdpConnector;
import org.mule.util.MapUtils;

public class UdpSocketFactory
implements KeyedPoolableObjectFactory {
    protected final transient Log logger = LogFactory.getLog(UdpSocketFactory.class);

    public Object makeObject(Object key) throws Exception {
        DatagramSocket socket;
        ImmutableEndpoint ep = (ImmutableEndpoint)key;
        if (ep instanceof InboundEndpoint) {
            int port = ep.getEndpointURI().getPort();
            String host = ep.getEndpointURI().getHost();
            socket = port > 0 ? ("null".equalsIgnoreCase(host) ? this.createSocket(port) : this.createSocket(port, InetAddress.getByName(host))) : this.createSocket();
        } else {
            socket = this.createSocket();
        }
        UdpConnector connector = (UdpConnector)ep.getConnector();
        if (connector.getReceiveBufferSize() != -1 && socket.getReceiveBufferSize() != connector.getReceiveBufferSize()) {
            socket.setReceiveBufferSize(connector.getReceiveBufferSize());
        }
        if (connector.getSendBufferSize() != -1 && socket.getSendBufferSize() != connector.getSendBufferSize()) {
            socket.setSendBufferSize(connector.getSendBufferSize());
        }
        if (connector.getTimeout() != -1 && socket.getSoTimeout() != connector.getTimeout()) {
            socket.setSoTimeout(connector.getTimeout());
        }
        socket.setBroadcast(connector.isBroadcast());
        return socket;
    }

    public void destroyObject(Object key, Object object) throws Exception {
        Socket socket = (Socket)object;
        if (!socket.isClosed()) {
            socket.close();
        }
    }

    public boolean validateObject(Object key, Object object) {
        DatagramSocket socket = (DatagramSocket)object;
        return !socket.isClosed();
    }

    public void activateObject(Object key, Object object) throws Exception {
    }

    public void passivateObject(Object key, Object object) throws Exception {
        ImmutableEndpoint ep = (ImmutableEndpoint)key;
        boolean keepSocketOpen = MapUtils.getBooleanValue((Map)ep.getProperties(), (Object)"keepSendSocketOpen", (boolean)((UdpConnector)ep.getConnector()).isKeepSendSocketOpen());
        DatagramSocket socket = (DatagramSocket)object;
        if (!keepSocketOpen && socket != null) {
            socket.close();
        }
    }

    protected DatagramSocket createSocket() throws IOException {
        return new DatagramSocket();
    }

    protected DatagramSocket createSocket(int port) throws IOException {
        return new DatagramSocket(port);
    }

    protected DatagramSocket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(port, inetAddress);
    }
}

