/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.NonDelegatingURIResolver;
import net.sf.saxon.RelativeURIResolver;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public class Document
extends SystemFunction
implements XSLTFunction {
    private String expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
            Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
            this.argument[0] = ExpressionTool.unsorted(optimizer, this.argument[0], false);
        }
    }

    public int computeCardinality() {
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return 57344;
        }
        return 24576;
    }

    public int computeSpecialProperties() {
        return 0x4A0000;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        Object object;
        int n = this.argument.length;
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        String string = null;
        if (n == 2) {
            object = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
            string = object.getBaseURI();
        }
        object = new DocumentMappingFunction(xPathContext);
        ((DocumentMappingFunction)object).baseURI = string;
        ((DocumentMappingFunction)object).stylesheetURI = this.expressionBaseURI;
        ((DocumentMappingFunction)object).locator = this;
        ItemMappingIterator itemMappingIterator = new ItemMappingIterator(sequenceIterator, (ItemMappingFunction)object);
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return new DocumentOrderIterator(itemMappingIterator, GlobalOrderComparer.getInstance());
        }
        return itemMappingIterator;
    }

    public static NodeInfo makeDoc(String string, String string2, XPathContext xPathContext, SourceLocator sourceLocator) throws XPathException {
        Object object;
        String string3;
        Controller controller;
        URIResolver uRIResolver;
        int n = string.indexOf(35);
        String string4 = null;
        if (n >= 0) {
            if (n == string.length() - 1) {
                string = string.substring(0, n);
            } else {
                string4 = string.substring(n + 1);
                string = string.substring(0, n);
                if (!xPathContext.getConfiguration().getNameChecker().isValidNCName(string4)) {
                    DynamicError dynamicError = new DynamicError("The fragment identifier " + Err.wrap(string4) + " is not a valid NCName");
                    dynamicError.setErrorCode("XTRE1160");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            }
        }
        if ((uRIResolver = (controller = xPathContext.getController()).getURIResolver()) instanceof RelativeURIResolver) {
            try {
                string3 = ((RelativeURIResolver)uRIResolver).makeAbsolute(string, string2);
            }
            catch (TransformerException transformerException) {
                string3 = '/' + string;
                string2 = "";
            }
        } else if (string2 == null) {
            try {
                string3 = new URI(string).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = '/' + string;
                string2 = "";
            }
        } else if (string.equals("")) {
            string3 = string2;
        } else {
            try {
                object = new URI(string2).resolve(string);
                string3 = ((URI)object).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = string2 + "/../" + string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string3 = string2 + "/../" + string;
            }
        }
        object = controller.getDocumentPool().find(string3);
        if (object != null) {
            return Document.getFragment((DocumentInfo)object, string4, xPathContext);
        }
        if (!controller.checkUniqueOutputDestination(string3)) {
            DynamicError dynamicError = new DynamicError("Cannot read a document that was written during the same transformation: " + string3);
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTRE1500");
            throw dynamicError;
        }
        try {
            DocumentInfo documentInfo;
            Configuration configuration;
            URIResolver uRIResolver2 = controller.getURIResolver();
            Source source = null;
            if (uRIResolver2 != null) {
                try {
                    source = uRIResolver2.resolve(string, string2);
                }
                catch (Exception exception) {
                    DynamicError dynamicError = new DynamicError("Exception thrown by URIResolver", exception);
                    if (controller.getConfiguration().isTraceExternalFunctions()) {
                        exception.printStackTrace();
                    }
                    dynamicError.setLocator(sourceLocator);
                    throw dynamicError;
                }
            }
            if (source == null && !(uRIResolver2 instanceof NonDelegatingURIResolver)) {
                uRIResolver2 = controller.getStandardURIResolver();
                source = uRIResolver2.resolve(string, string2);
            }
            if ((source = (configuration = controller.getConfiguration()).getSourceResolver().resolveSource(source, configuration)) instanceof NodeInfo || source instanceof DOMSource) {
                NodeInfo nodeInfo = controller.prepareInputTree(source);
                documentInfo = nodeInfo.getDocumentRoot();
            } else {
                Builder builder = controller.makeBuilder();
                Receiver receiver = controller.makeStripper(builder);
                if (controller.getExecutable().stripsInputTypeAnnotations()) {
                    receiver = controller.getConfiguration().getAnnotationStripper(receiver);
                }
                new Sender(controller.makePipelineConfiguration()).send(source, receiver);
                documentInfo = (DocumentInfo)builder.getCurrentRoot();
                if (source instanceof AugmentedSource && ((AugmentedSource)source).isPleaseCloseAfterUse()) {
                    ((AugmentedSource)source).close();
                }
            }
            controller.registerDocument(documentInfo, string3);
            controller.addUnavailableOutputDestination(string3);
            return Document.getFragment(documentInfo, string4, xPathContext);
        }
        catch (TransformerException transformerException) {
            DynamicError dynamicError = DynamicError.makeDynamicError(transformerException);
            dynamicError.setLocator(sourceLocator);
            dynamicError.setErrorCode("FODC0005");
            try {
                controller.recoverableError(dynamicError);
            }
            catch (XPathException xPathException) {
                throw new DynamicError(transformerException);
            }
            return null;
        }
    }

    public void sendDocuments(XPathContext xPathContext, Receiver receiver) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        String string = null;
        if (this.argument.length == 2) {
            item = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
            string = item.getBaseURI();
        }
        while ((item = sequenceIterator.next()) != null) {
            String string2 = string == null ? (item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : this.expressionBaseURI) : string;
            Document.sendDoc(item.getStringValue(), string2, xPathContext, this, receiver);
        }
    }

    public static void sendDoc(String string, String string2, XPathContext xPathContext, SourceLocator sourceLocator, Receiver receiver) throws XPathException {
        Object object;
        String string3;
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        if (pipelineConfiguration == null) {
            pipelineConfiguration = xPathContext.getController().makePipelineConfiguration();
        }
        if (string2 == null) {
            try {
                string3 = new URI(string).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = '/' + string;
                string2 = "";
            }
        } else if (string.equals("")) {
            string3 = string2;
        } else {
            try {
                object = new URI(string2).resolve(string);
                string3 = ((URI)object).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                string3 = string2 + "/../" + string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string3 = string2 + "/../" + string;
            }
        }
        object = xPathContext.getController();
        DocumentInfo documentInfo = ((Controller)object).getDocumentPool().find(string3);
        Source source = null;
        if (documentInfo != null) {
            source = documentInfo;
        } else {
            try {
                URIResolver uRIResolver = ((Controller)object).getURIResolver();
                if (uRIResolver != null) {
                    source = uRIResolver.resolve(string, string2);
                }
                if (source == null) {
                    uRIResolver = ((Controller)object).getStandardURIResolver();
                    source = uRIResolver.resolve(string, string2);
                }
                if (source instanceof NodeInfo || source instanceof DOMSource) {
                    NodeInfo nodeInfo = ((Controller)object).prepareInputTree(source);
                    source = nodeInfo.getDocumentRoot();
                }
            }
            catch (TransformerException transformerException) {
                DynamicError dynamicError = DynamicError.makeDynamicError(transformerException);
                dynamicError.setLocator(sourceLocator);
                dynamicError.setErrorCode("FODC0005");
                throw dynamicError;
            }
        }
        receiver = ((Controller)object).makeStripper(receiver);
        receiver.setPipelineConfiguration(pipelineConfiguration);
        if (((Controller)object).getExecutable().stripsInputTypeAnnotations()) {
            receiver = ((Controller)object).getConfiguration().getAnnotationStripper(receiver);
            receiver.setPipelineConfiguration(pipelineConfiguration);
        }
        new Sender(pipelineConfiguration).send(source, receiver);
    }

    private static NodeInfo getFragment(DocumentInfo documentInfo, String string, XPathContext xPathContext) throws XPathException {
        if (string == null) {
            return documentInfo;
        }
        if (!xPathContext.getConfiguration().getNameChecker().isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Invalid fragment identifier in URI");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTRE1160");
            try {
                xPathContext.getController().recoverableError(dynamicError);
            }
            catch (DynamicError dynamicError2) {
                throw dynamicError;
            }
            return documentInfo;
        }
        return documentInfo.selectID(string);
    }

    private static class DocumentMappingFunction
    implements ItemMappingFunction {
        public String baseURI;
        public String stylesheetURI;
        public SourceLocator locator;
        public XPathContext context;

        public DocumentMappingFunction(XPathContext xPathContext) {
            this.context = xPathContext;
        }

        public Item map(Item item) throws XPathException {
            if (this.baseURI == null) {
                this.baseURI = item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : this.stylesheetURI;
            }
            NodeInfo nodeInfo = Document.makeDoc(item.getStringValue(), this.baseURI, this.context, this.locator);
            return nodeInfo;
        }
    }
}

