/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.AlphanumericComparer;
import net.sf.saxon.sort.LowercaseFirstComparer;
import net.sf.saxon.sort.NamedCollation;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.sort.UppercaseFirstComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public abstract class JavaCollationFactory {
    private JavaCollationFactory() {
    }

    public static StringCollator makeCollation(Configuration configuration, String string, Properties properties) throws XPathException {
        String string2;
        Object object;
        Collator collator = null;
        StringCollator stringCollator = null;
        String string3 = properties.getProperty("class");
        if (string3 != null) {
            object = configuration.getInstance(string3, null);
            if (object instanceof Collator) {
                collator = (Collator)object;
            } else if (object instanceof StringCollator) {
                stringCollator = (StringCollator)object;
            } else if (object instanceof Comparator) {
                stringCollator = new NamedCollation(string, (Comparator)object);
            } else {
                throw new DynamicError("Requested collation class " + string3 + " is not a Comparator");
            }
        }
        if (collator == null && stringCollator == null) {
            object = properties.getProperty("rules");
            if (object != null && collator == null) {
                try {
                    collator = new RuleBasedCollator((String)object);
                }
                catch (ParseException parseException) {
                    throw new DynamicError("Invalid collation rules: " + parseException.getMessage());
                }
            }
            if (collator == null) {
                string2 = properties.getProperty("lang");
                collator = string2 != null ? Collator.getInstance(JavaCollationFactory.getLocale(string2)) : Collator.getInstance();
            }
        }
        if (collator != null) {
            String string4;
            object = properties.getProperty("strength");
            if (object != null) {
                if (((String)object).equals("primary") && collator instanceof Collator) {
                    collator.setStrength(0);
                } else if (((String)object).equals("secondary")) {
                    collator.setStrength(1);
                } else if (((String)object).equals("tertiary")) {
                    collator.setStrength(2);
                } else if (((String)object).equals("identical")) {
                    collator.setStrength(3);
                } else {
                    throw new DynamicError("strength must be primary, secondary, tertiary, or identical");
                }
            }
            if ((string2 = properties.getProperty("ignore-width")) != null) {
                if (string2.equals("yes") && object == null && collator instanceof Collator) {
                    collator.setStrength(2);
                } else if (!string2.equals("no")) {
                    throw new DynamicError("ignore-width must be yes or no");
                }
            }
            if ((string2 = properties.getProperty("ignore-case")) != null && object == null && collator instanceof Collator) {
                if (string2.equals("yes")) {
                    collator.setStrength(1);
                } else if (!string2.equals("no")) {
                    throw new DynamicError("ignore-case must be yes or no");
                }
            }
            if ((string2 = properties.getProperty("ignore-modifiers")) != null) {
                if (string2.equals("yes") && object == null && collator instanceof Collator) {
                    collator.setStrength(0);
                } else if (!string2.equals("no")) {
                    throw new DynamicError("ignore-modifiers must be yes or no");
                }
            }
            if ((string4 = properties.getProperty("decomposition")) != null && collator instanceof Collator) {
                if (string4.equals("none")) {
                    collator.setDecomposition(0);
                } else if (string4.equals("standard")) {
                    collator.setDecomposition(1);
                } else if (string4.equals("full")) {
                    collator.setDecomposition(2);
                } else {
                    throw new DynamicError("decomposition must be non, standard, or full");
                }
            }
        }
        if (stringCollator == null) {
            stringCollator = new NamedCollation(string, collator);
        }
        if ((object = properties.getProperty("case-order")) != null && !"#default".equals(object)) {
            collator.setStrength(1);
            if (((String)object).equals("lower-first")) {
                stringCollator = new LowercaseFirstComparer(stringCollator);
            } else if (((String)object).equals("upper-first")) {
                stringCollator = new UppercaseFirstComparer(stringCollator);
            } else {
                throw new DynamicError("case-order must be lower-first, upper-first, or #default");
            }
        }
        if ((string2 = properties.getProperty("alphanumeric")) != null && !"no".equals(string2)) {
            if (string2.equals("yes")) {
                stringCollator = new AlphanumericComparer(stringCollator);
            } else {
                throw new DynamicError("alphanumeric must be yes or no");
            }
        }
        return stringCollator;
    }

    private static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }
}

