/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ibeans.api.AbstractCallInterceptor;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Response;
import org.ibeans.api.channel.MimeType;
import org.ibeans.api.channel.MimeTypes;

public class LogResponsesInterceptor
extends AbstractCallInterceptor {
    private File logDirectory;

    public LogResponsesInterceptor(String logDirectory) {
        this(new File(logDirectory));
    }

    public LogResponsesInterceptor(File logDirectory) {
        if (!logDirectory.exists()) {
            throw new IllegalArgumentException("Log directory does not exist: " + logDirectory);
        }
        if (!logDirectory.isDirectory()) {
            throw new IllegalArgumentException("Log directory is not a directory: " + logDirectory);
        }
        this.logDirectory = logDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCall(InvocationContext invocationContext) throws Throwable {
        Response msg = invocationContext.getResponse();
        boolean isStream = InputStream.class.isAssignableFrom(msg.getPayload().getClass());
        String response = msg.getPayload().toString();
        if (isStream) {
            invocationContext.setResult(new ByteArrayInputStream(response.getBytes()));
        } else {
            invocationContext.setResult(response);
        }
        String type = (String)msg.getHeader("Content-Type");
        String testMethod = this.getTestMethod(invocationContext.getMethod().getName());
        String ext = this.getFileExtension(new MimeType(type));
        int i = 1;
        String filename = testMethod + "-response" + i++ + ext;
        File responseFile = new File(this.logDirectory, filename);
        while (responseFile.exists()) {
            filename = testMethod + "-response" + i++ + ext;
            responseFile = new File(this.logDirectory, filename);
        }
        FileOutputStream fos = LogResponsesInterceptor.openOutputStream(responseFile);
        try {
            fos.write(response.getBytes());
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {}
        }
    }

    protected String getFileExtension(MimeType mimeType) {
        if (mimeType == null) {
            return ".data";
        }
        if (mimeType.equals((Object)MimeTypes.ATOM)) {
            return ".atom";
        }
        if (mimeType.equals((Object)MimeTypes.RSS)) {
            return ".rss";
        }
        if (mimeType.equals((Object)MimeTypes.XML) || mimeType.equals((Object)MimeTypes.APPLICATION_XML)) {
            return ".xml";
        }
        if (mimeType.equals((Object)MimeTypes.JSON)) {
            return ".json";
        }
        if (mimeType.equals((Object)MimeTypes.TEXT)) {
            return ".txt";
        }
        if (mimeType.equals((Object)MimeTypes.HTML)) {
            return ".html";
        }
        return ".data";
    }

    private String getTestMethod(String name) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement element = stack[i];
            if (!element.getMethodName().equals(name)) continue;
            String className = stack[i + 1].getClassName();
            int x = className.lastIndexOf(".");
            if (x > -1) {
                className = className.substring(x + 1);
            }
            return className + "-" + stack[i + 1].getMethodName();
        }
        throw new IllegalStateException("Method not found in call stack");
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }
}

