/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.types.DataTypeFactory;

public class DefaultMessageCollection
extends DefaultMuleMessage
implements MuleMessageCollection {
    private List messageList = new CopyOnWriteArrayList();
    private boolean invalidatedPayload = false;

    public DefaultMessageCollection(MuleContext muleContext) {
        super(new CopyOnWriteArrayList(), muleContext);
    }

    public DefaultMessageCollection(DefaultMessageCollection msg, MuleContext muleContext) {
        this(msg, muleContext, false);
    }

    public DefaultMessageCollection(DefaultMessageCollection msg, MuleContext muleContext, boolean deepMessageCopy) {
        this(muleContext);
        this.setUniqueId(msg.getUniqueId());
        this.setMessageRootId(msg.getMessageRootId());
        this.copyMessageProperties(msg);
        if (!msg.invalidatedPayload) {
            for (int i = 0; i < msg.getMessagesAsArray().length; ++i) {
                MuleMessage currentMsg = msg.getMessagesAsArray()[i];
                if (deepMessageCopy) {
                    if (currentMsg instanceof MuleMessageCollection) {
                        this.addMessage(new DefaultMessageCollection((DefaultMessageCollection)currentMsg, muleContext, true));
                        continue;
                    }
                    this.addMessage(new DefaultMuleMessage((Object)currentMsg, currentMsg, muleContext));
                    continue;
                }
                this.addMessage(currentMsg);
            }
        } else {
            this.invalidatedPayload = true;
        }
    }

    protected void checkValidPayload() {
        if (this.invalidatedPayload) {
            throw new IllegalStateException("Payload was invalidated calling setPayload and the message is not collection anymore.");
        }
    }

    @Override
    public void addMessage(MuleMessage message) {
        this.checkValidPayload();
        this.getMessageList().add(message);
        this.getPayloadList().add(message.getPayload());
    }

    @Override
    public MuleMessage[] getMessagesAsArray() {
        this.checkValidPayload();
        List list = this.getMessageList();
        MuleMessage[] messages = new MuleMessage[list.size()];
        messages = list.toArray(messages);
        return messages;
    }

    @Override
    public Object[] getPayloadsAsArray() {
        this.checkValidPayload();
        List list = this.getPayloadList();
        Object[] payloads = new Object[list.size()];
        payloads = list.toArray(payloads);
        return payloads;
    }

    @Override
    public void removedMessage(MuleMessage message) {
        this.checkValidPayload();
        this.getMessageList().remove(message);
        this.getPayloadList().remove(message.getPayload());
    }

    @Override
    public void addMessage(MuleMessage message, int index) {
        this.checkValidPayload();
        this.getMessageList().add(index, message);
        this.getPayloadList().add(index, message.getPayload());
    }

    @Override
    public void addMessages(MuleEvent[] events) {
        this.checkValidPayload();
        for (int i = 0; i < events.length; ++i) {
            MuleEvent event = events[i];
            this.addMessage(event.getMessage());
        }
    }

    @Override
    public void addMessages(List messages) {
        this.checkValidPayload();
        for (MuleMessage message : messages) {
            this.addMessage(message);
        }
    }

    @Override
    public void addMessages(MuleMessage[] messages) {
        this.checkValidPayload();
        for (int i = 0; i < messages.length; ++i) {
            this.addMessage(messages[i]);
        }
    }

    @Override
    public MuleMessage getMessage(int index) {
        this.checkValidPayload();
        return (MuleMessage)this.getMessageList().get(index);
    }

    protected List getMessageList() {
        this.checkValidPayload();
        return this.messageList;
    }

    protected List getPayloadList() {
        this.checkValidPayload();
        return (List)this.getPayload();
    }

    @Override
    public synchronized void setPayload(Object payload) {
        if (this.getPayload() == payload) {
            return;
        }
        super.setPayload(payload);
        this.invalidatedPayload = true;
    }

    public Object getPayload(Class outputType) throws TransformerException {
        if (this.invalidatedPayload) {
            return super.getPayload(outputType);
        }
        DataType outputDataType = DataTypeFactory.create(outputType);
        ArrayList results = new ArrayList(this.getMessageList().size());
        for (MuleMessage message : this.getMessageList()) {
            results.add(message.getPayload(outputDataType));
        }
        return results;
    }

    @Override
    public int size() {
        this.checkValidPayload();
        return this.getMessageList().size();
    }

    @Override
    public byte[] getPayloadAsBytes() throws Exception {
        if (this.invalidatedPayload) {
            return super.getPayloadAsBytes();
        }
        throw new UnsupportedOperationException("getPayloadAsBytes(), use getPayload(DataType.BYTE_ARRAY_DATA_TYPE)");
    }

    @Override
    public String getPayloadAsString(String encoding) throws Exception {
        if (this.invalidatedPayload) {
            return super.getPayloadAsString(encoding);
        }
        throw new UnsupportedOperationException("getPayloadAsString(), use getPayload(DataType.STRING_DATA_TYPE)");
    }

    @Override
    public String getPayloadForLogging(String encoding) {
        if (this.invalidatedPayload) {
            return super.getPayloadForLogging(encoding);
        }
        return "[This is a message collection]";
    }

    @Override
    public String getPayloadForLogging() {
        if (this.invalidatedPayload) {
            return super.getPayloadForLogging();
        }
        return "[This is a message collection]";
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        this.checkValidPayload();
        return new DefaultMessageCollection(this, this.muleContext, true);
    }

    @Override
    public MuleMessage createInboundMessage() throws Exception {
        MuleMessage[] messages;
        if (this.invalidatedPayload) {
            return super.createInboundMessage();
        }
        DefaultMessageCollection newMessage = new DefaultMessageCollection(this.getMuleContext());
        newMessage.setUniqueId(this.getUniqueId());
        newMessage.setMessageRootId(this.getMessageRootId());
        for (MuleMessage message : messages = this.getMessagesAsArray()) {
            newMessage.addMessage(message.createInboundMessage());
        }
        this.copyToInbound(newMessage);
        return newMessage;
    }

    public boolean isInvalidatedPayload() {
        return this.invalidatedPayload;
    }
}

