/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEventContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.component.BindingUtils;
import org.mule.component.ComponentException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.registry.JSR250ValidatorProcessor;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class DefaultComponentLifecycleAdapter
implements LifecycleAdapter {
    protected static final Log logger = LogFactory.getLog(DefaultComponentLifecycleAdapter.class);
    protected Object componentObject;
    protected JavaComponent component;
    protected EntryPointResolverSet entryPointResolver;
    protected FlowConstruct flowConstruct;
    protected boolean isInitialisable = false;
    protected boolean isStartable = false;
    protected boolean isStoppable = false;
    protected boolean isDisposable = false;
    protected Method initMethod;
    protected Method disposeMethod;
    private boolean started = false;
    private boolean disposed = false;
    protected MuleContext muleContext;

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, MuleContext muleContext) throws MuleException {
        if (muleContext == null) {
            throw new IllegalStateException("No muleContext provided");
        }
        if (componentObject == null) {
            throw new IllegalArgumentException("POJO Service cannot be null");
        }
        if (this.entryPointResolver == null) {
            this.entryPointResolver = new LegacyEntryPointResolverSet();
        }
        this.componentObject = componentObject;
        this.component = component;
        this.flowConstruct = flowConstruct;
        this.muleContext = muleContext;
        this.setLifecycleFlags();
        BindingUtils.configureBinding(component, componentObject);
    }

    public DefaultComponentLifecycleAdapter(Object componentObject, JavaComponent component, FlowConstruct flowConstruct, EntryPointResolverSet entryPointResolver, MuleContext muleContext) throws MuleException {
        this(componentObject, component, flowConstruct, muleContext);
        this.entryPointResolver = entryPointResolver;
    }

    protected void setLifecycleFlags() {
        Object object = this.componentObject;
        this.initMethod = this.findInitMethod(object);
        this.disposeMethod = this.findDisposeMethod(object);
        this.isInitialisable = this.initMethod != null;
        this.isDisposable = this.disposeMethod != null;
        this.isStartable = Startable.class.isInstance(object);
        this.isStoppable = Stoppable.class.isInstance(object);
    }

    protected Method findInitMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Initialisable) {
            try {
                return object.getClass().getMethod("initialise", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PostConstruct.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePostConstructAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    protected Method findDisposeMethod(Object object) {
        List<AnnotationMetaData> metaData;
        if (object instanceof Disposable) {
            try {
                return object.getClass().getMethod("dispose", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if ((metaData = AnnotationUtils.getMethodAnnotations(object.getClass(), PreDestroy.class)).size() == 0) {
            return null;
        }
        if (metaData.size() > 1) {
            throw new IllegalArgumentException(CoreMessages.objectHasMoreThanOnePreDestroyAnnotation(object.getClass()).getMessage());
        }
        Method m = (Method)metaData.get(0).getMember();
        new JSR250ValidatorProcessor().validateLifecycleMethod(m);
        return m;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.isInitialisable) {
            try {
                this.initMethod.invoke(this.componentObject, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
            catch (InvocationTargetException e) {
                throw new InitialisationException(e.getTargetException(), (Initialisable)this);
            }
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.isStartable) {
            try {
                ((Startable)this.componentObject).start();
                this.started = true;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStart("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = true;
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.componentObject).stop();
                this.started = false;
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.failedToStop("Service: " + this.flowConstruct.getName()), (Throwable)e);
            }
        } else {
            this.started = false;
        }
    }

    @Override
    public void dispose() {
        try {
            Object o;
            if (this.isDisposable && (o = this.componentObject) != null) {
                try {
                    this.disposeMethod.invoke(o, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            this.componentObject = null;
        }
        catch (Throwable e) {
            logger.error((Object)("failed to dispose: " + this.flowConstruct.getName()), e);
        }
        this.disposed = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public Object invoke(MuleEvent event) throws MuleException {
        Object result;
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(event);
        try {
            if (this.componentObject == null) {
                throw new ComponentException(MessageFactory.createStaticMessage("componentObject is null"), RequestContext.getEvent(), this.component);
            }
            result = this.component.getEntryPointResolverSet() != null ? this.component.getEntryPointResolverSet().invoke(this.componentObject, eventContext) : this.entryPointResolver.invoke(this.componentObject, eventContext);
        }
        catch (Exception e) {
            throw new ComponentException(RequestContext.getEvent(), this.component, (Throwable)e);
        }
        return result;
    }
}

