/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.routing.requestreply.AsyncReplyToPropertyRequestReplyReplier;

public class Flow
extends AbstractPipeline
implements MessageProcessor {
    private int stageCount = 0;
    private int asyncCount = 0;

    public Flow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.processingStrategy = new DefaultFlowProcessingStrategy();
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        final DefaultMuleEvent newEvent = new DefaultMuleEvent(event, this);
        RequestContext.setEvent(newEvent);
        try {
            ErrorHandlingExecutionTemplate executionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate(this.muleContext, this.getExceptionListener());
            MuleEvent result = executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                @Override
                public MuleEvent process() throws Exception {
                    MuleEvent result = Flow.this.pipeline.process(newEvent);
                    if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
                        result.getMessage().release();
                    }
                    return result;
                }
            });
            if (result != null && !VoidMuleEvent.getInstance().equals(result)) {
                result = new DefaultMuleEvent(result, event.getFlowConstruct());
            }
            MuleEvent muleEvent = result;
            return muleEvent;
        }
        catch (MessagingException e) {
            e.setProcessedEvent(new DefaultMuleEvent(e.getEvent(), event.getFlowConstruct()));
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.createStaticMessage("Flow execution exception"), (Throwable)e);
        }
        finally {
            RequestContext.setEvent(event);
            event.getMessage().release();
        }
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new AbstractPipeline.ProcessIfPipelineStartedMessageProcessor());
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
    }

    @Override
    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new AsyncReplyToPropertyRequestReplyReplier());
        super.configurePostProcessors(builder);
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    @Override
    protected void configureStatistics() {
        this.statistics = this.processingStrategy instanceof AsynchronousProcessingStrategy && ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads() != null ? new FlowConstructStatistics(this.getConstructType(), this.name, ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads()) : new FlowConstructStatistics(this.getConstructType(), this.name);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    @Override
    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.stage%s", Flow.this.getName(), ++Flow.this.stageCount);
            }
        }, builder, this.muleContext);
    }

    public ProcessingStrategy.StageNameSource getAsyncStageNameSource() {
        return new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.async%s", Flow.this.getName(), ++Flow.this.asyncCount);
            }
        };
    }

    public ProcessingStrategy.StageNameSource getAsyncStageNameSource(final String asyncName) {
        return new ProcessingStrategy.StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.%s", Flow.this.getName(), asyncName);
            }
        };
    }
}

