/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.mule.api.MuleRuntimeException;

public abstract class AbstractMapContext<K, V>
implements Map<K, V> {
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (Object key : this.keySet()) {
            try {
                this.remove(key);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList(this.size());
        for (Object key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (Object key : this.keySet()) {
            entrySet.add((Map.Entry<K, V>)new DefaultMapEntry(key, this.get(key)));
        }
        return entrySet;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object key : this.keySet()) {
            if (!value.equals(this.get(key))) continue;
            return true;
        }
        return false;
    }
}

