/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.text.MessageFormat;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionEnricher;
import org.mule.config.i18n.CoreMessages;

public class AttachmentExpressionEnricher
implements ExpressionEnricher {
    public static final String NAME = "attachment";

    @Override
    public void enrich(String expression, MuleMessage message, Object object) {
        if (object instanceof DataHandler) {
            try {
                message.addOutboundAttachment(expression, (DataHandler)object);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
        String[] split = expression.split(",");
        if (split.length < 2) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage(MessageFormat.format("attachment enrichment expression {0} does not declare a content type", expression)));
        }
        String attachmentName = split[0];
        String contentType = split[1];
        try {
            message.addOutboundAttachment(attachmentName, object, contentType);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.createStaticMessage("failed to set attachment"));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

