/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ProcessingTimeWatcher;

public class ProcessingTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AtomicLong accumulator = new AtomicLong();
    private FlowConstructStatistics statistics;

    public static ProcessingTime newInstance(MuleEvent event) {
        FlowConstructStatistics stats;
        FlowConstruct fc;
        if (event != null && (fc = event.getFlowConstruct()) != null && (stats = fc.getStatistics()) != null && fc.getStatistics().isEnabled()) {
            return new ProcessingTime(stats, event.getMuleContext());
        }
        return null;
    }

    private ProcessingTime(FlowConstructStatistics stats, MuleContext muleContext) {
        this.statistics = stats;
        ProcessingTimeWatcher processorTimeWatcher = muleContext.getProcessorTimeWatcher();
        processorTimeWatcher.addProcessingTime(this);
    }

    public void addFlowExecutionBranchTime(long startTime) {
        if (this.statistics.isEnabled()) {
            long elapsedTime = ProcessingTime.getEffectiveTime(System.currentTimeMillis() - startTime);
            this.statistics.addFlowExecutionBranchTime(elapsedTime, this.accumulator.addAndGet(elapsedTime));
        }
    }

    public static long getEffectiveTime(long time) {
        return time <= 0L ? 1L : time;
    }

    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    public AtomicLong getAccumulator() {
        return this.accumulator;
    }
}

