/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointNotFoundException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.util.StringUtils;

public class EndpointSelector
extends FilteringOutboundRouter {
    public static final String DEFAULT_SELECTOR_EVALUATOR = "header";
    public static final String DEFAULT_SELECTOR_EXPRESSION = "endpoint";
    private String defaultEndpointName;
    private ExpressionConfig expressionConfig = new ExpressionConfig("endpoint", "header", null);

    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        List endpoints;
        MuleMessage message = event.getMessage();
        String prop = this.expressionConfig.getFullExpression(this.expressionManager);
        if (!this.expressionManager.isValidExpression(prop)) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionInvalidForProperty("expression", prop), event, null);
        }
        Object property = null;
        try {
            property = this.expressionManager.evaluate(prop, event);
        }
        catch (ExpressionRuntimeException e) {
            this.logger.error((Object)e.getMessage());
        }
        if (property == null && this.getDefaultEndpointName() == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionResultWasNull(this.expressionConfig.getFullExpression(this.expressionManager)), event, null);
        }
        if (property == null) {
            this.logger.info((Object)("Expression: " + prop + " returned null, using default endpoint: " + this.getDefaultEndpointName()));
            property = this.getDefaultEndpointName();
        }
        if (property instanceof String) {
            endpoints = new ArrayList<Object>(1);
            endpoints.add(property);
        } else if (property instanceof List) {
            endpoints = (List)property;
        } else {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.expressionConfig.getFullExpression(this.expressionManager), new Class[]{String.class, List.class}, property.getClass()), event, null);
        }
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>(endpoints.size());
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            String endpointName = iterator.next().toString();
            if (StringUtils.isEmpty((String)endpointName)) {
                throw new CouldNotRouteOutboundMessageException(CoreMessages.objectIsNull("Endpoint Name: " + this.expressionConfig.getFullExpression(this.expressionManager)), event, null);
            }
            MessageProcessor ep = null;
            try {
                ep = this.lookupEndpoint(endpointName);
                if (ep == null) {
                    throw new CouldNotRouteOutboundMessageException(CoreMessages.objectNotFound("Endpoint", endpointName), event, null);
                }
                MuleEvent result = this.sendRequest(event, message, ep, true);
                if (result == null || VoidMuleEvent.getInstance().equals(result)) continue;
                results.add(result);
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(event, ep, (Throwable)e);
            }
        }
        return this.resultsHandler.aggregateResults(results, event, this.muleContext);
    }

    protected MessageProcessor lookupEndpoint(String endpointName) throws MuleException {
        for (MessageProcessor target : this.routes) {
            if (!(target instanceof ImmutableEndpoint)) continue;
            ImmutableEndpoint ep = (ImmutableEndpoint)((Object)target);
            if (endpointName.equals(ep.getName())) {
                return target;
            }
            if (endpointName.equals(ep.getName())) {
                return target;
            }
            if (!endpointName.equals(ep.getEndpointURI().getUri().toString())) continue;
            return target;
        }
        try {
            return this.getMuleContext().getEndpointFactory().getOutboundEndpoint(endpointName);
        }
        catch (MalformedEndpointException e) {
            throw new EndpointNotFoundException(CoreMessages.endpointNotFound(endpointName), (Throwable)e);
        }
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public String getCustomEvaluator() {
        return this.expressionConfig.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.expressionConfig.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.expressionConfig.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.expressionConfig.setEvaluator(evaluator);
    }

    public String getDefaultEndpointName() {
        return this.defaultEndpointName;
    }

    public void setDefaultEndpointName(String defaultEndpointName) {
        this.defaultEndpointName = defaultEndpointName;
    }
}

