/*
 * Decompiled with CFR 0.152.
 */
package org.mule.source;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.ClusterizableMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.lifecycle.PrimaryNodeLifecycleNotificationListener;

public class ClusterizableMessageSourceWrapper
implements MessageSource,
Lifecycle,
MuleContextAware,
FlowConstructAware {
    protected static final Log logger = LogFactory.getLog(ClusterizableMessageSourceWrapper.class);
    private PrimaryNodeLifecycleNotificationListener primaryNodeLifecycleNotificationListener;
    private final ClusterizableMessageSource messageSource;
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private final Object lock = new Object();
    private boolean started;
    private boolean messageSourceStarted;

    public ClusterizableMessageSourceWrapper(ClusterizableMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ClusterizableMessageSourceWrapper(MuleContext muleContext, ClusterizableMessageSource messageSource, FlowConstruct flowConstruct) {
        this.messageSource = messageSource;
        this.setMuleContext(muleContext);
        this.setFlowConstruct(flowConstruct);
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.messageSource.setListener(listener);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.primaryNodeLifecycleNotificationListener = new PrimaryNodeLifecycleNotificationListener(new Startable(){

            @Override
            public void start() throws MuleException {
                if (ClusterizableMessageSourceWrapper.this.isStarted()) {
                    ClusterizableMessageSourceWrapper.this.start();
                }
            }
        }, this.muleContext);
        this.primaryNodeLifecycleNotificationListener.register();
        if (this.messageSource instanceof Initialisable) {
            ((Initialisable)((Object)this.messageSource)).initialise();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        Object object = this.lock;
        synchronized (object) {
            if (this.messageSourceStarted) {
                return;
            }
            if (this.messageSource instanceof Startable) {
                if (this.muleContext.isPrimaryPollingInstance()) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Starting clusterizable message source");
                    }
                    ((Startable)((Object)this.messageSource)).start();
                    this.messageSourceStarted = true;
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Clusterizable message source no started on secondary cluster node");
                }
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                if (this.messageSource instanceof Stoppable) {
                    ((Stoppable)((Object)this.messageSource)).stop();
                }
                this.started = false;
                this.messageSourceStarted = false;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.messageSource instanceof Disposable) {
            ((Disposable)((Object)this.messageSource)).dispose();
        }
        this.primaryNodeLifecycleNotificationListener.unregister();
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        if (this.messageSource instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)this.messageSource)).setFlowConstruct(flowConstruct);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.messageSource instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.messageSource)).setMuleContext(this.muleContext);
        }
    }

    public boolean isStarted() {
        return this.started;
    }
}

