/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.compression.AbstractCompressionTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.SerializationUtils;
import org.mule.util.compression.GZipCompression;

public class GZipCompressTransformer
extends AbstractCompressionTransformer {
    public GZipCompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataTypeFactory.create(Serializable.class));
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            if (src instanceof InputStream) {
                return this.getStrategy().compressInputStream((InputStream)src);
            }
            byte[] data = src instanceof byte[] ? (byte[])src : SerializationUtils.serialize((Serializable)((Serializable)src));
            return this.getStrategy().compressByteArray(data);
        }
        catch (IOException ioex) {
            throw new TransformerException(this, (Throwable)ioex);
        }
    }
}

