/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.component.JavaComponent;
import org.mule.api.object.ObjectFactory;
import org.mule.component.BindingUtils;

public class MuleComponentProviderFactory
implements IoCComponentProviderFactory {
    private final List<JavaComponent> components;
    private final MuleContext muleContext;

    public MuleComponentProviderFactory(MuleContext muleContext, List<JavaComponent> components) {
        this.muleContext = muleContext;
        this.components = components;
    }

    public IoCComponentProvider getComponentProvider(Class<?> cls) {
        for (JavaComponent c : this.components) {
            if (!c.getObjectType().isAssignableFrom(cls)) continue;
            return this.getComponentProvider(null, cls);
        }
        return null;
    }

    public IoCComponentProvider getComponentProvider(ComponentContext ctx, Class<?> cls) {
        final JavaComponent selected = this.getSelectedComponent(cls);
        if (selected == null) {
            return null;
        }
        return new IoCInstantiatedComponentProvider(){

            public Object getInjectableInstance(Object o) {
                return o;
            }

            public Object getInstance() {
                try {
                    ObjectFactory objectFactory = selected.getObjectFactory();
                    Object instance = objectFactory.getInstance(MuleComponentProviderFactory.this.muleContext);
                    BindingUtils.configureBinding((JavaComponent)selected, (Object)instance);
                    return instance;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private JavaComponent getSelectedComponent(Class<?> cls) {
        JavaComponent selected = null;
        for (JavaComponent c : this.components) {
            if (!c.getObjectType().isAssignableFrom(cls)) continue;
            selected = c;
        }
        return selected;
    }
}

