/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.Label;
import org.antlr.analysis.NFA;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;

public class NFAState
extends State {
    public static final int LOOPBACK = 1;
    public static final int BLOCK_START = 2;
    public static final int OPTIONAL_BLOCK_START = 3;
    public static final int BYPASS = 4;
    public static final int RIGHT_EDGE_OF_BLOCK = 5;
    public static final int MAX_TRANSITIONS = 2;
    int numTransitions = 0;
    public Transition[] transition = new Transition[2];
    public Label incidentEdgeLabel;
    public NFA nfa = null;
    protected int decisionNumber = 0;
    public int decisionStateType;
    public Rule enclosingRule;
    protected String description;
    public GrammarAST associatedASTNode;
    protected boolean EOTTargetState = false;
    public int endOfBlockStateNumber = -1;

    public NFAState(NFA nFA) {
        this.nfa = nFA;
    }

    public int getNumberOfTransitions() {
        return this.numTransitions;
    }

    public void addTransition(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException("You can't add a null transition");
        }
        if (this.numTransitions > this.transition.length) {
            throw new IllegalArgumentException("You can only have " + this.transition.length + " transitions");
        }
        if (transition != null) {
            this.transition[this.numTransitions] = transition;
            ++this.numTransitions;
            Label label = transition.label;
            if (label.isAtom() || label.isSet()) {
                if (((NFAState)transition.target).incidentEdgeLabel != null) {
                    ErrorManager.internalError("Clobbered incident edge");
                }
                ((NFAState)transition.target).incidentEdgeLabel = transition.label;
            }
        }
    }

    public void setTransition0(Transition transition) {
        if (transition == null) {
            throw new IllegalArgumentException("You can't use a solitary null transition");
        }
        this.transition[0] = transition;
        this.transition[1] = null;
        this.numTransitions = 1;
    }

    public Transition transition(int n) {
        return this.transition[n];
    }

    public int translateDisplayAltToWalkAlt(int n) {
        NFAState nFAState = this;
        if (this.decisionNumber == 0 || this.decisionStateType == 0) {
            return n;
        }
        int n2 = 0;
        int n3 = this.nfa.grammar.getNumberOfAltsForDecisionNFA(nFAState);
        switch (nFAState.decisionStateType) {
            case 1: {
                n2 = n % n3 + 1;
                break;
            }
            case 2: 
            case 3: {
                n2 = n;
                break;
            }
            case 4: {
                n2 = n == n3 ? 2 : 1;
            }
        }
        return n2;
    }

    public void setDecisionASTNode(GrammarAST grammarAST) {
        grammarAST.setNFAStartState(this);
        this.associatedASTNode = grammarAST;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getDecisionNumber() {
        return this.decisionNumber;
    }

    public void setDecisionNumber(int n) {
        this.decisionNumber = n;
    }

    public boolean isEOTTargetState() {
        return this.EOTTargetState;
    }

    public void setEOTTargetState(boolean bl) {
        this.EOTTargetState = bl;
    }

    public boolean isDecisionState() {
        return this.decisionStateType > 0;
    }

    public String toString() {
        return String.valueOf(this.stateNumber);
    }
}

