/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.el.context.AbstractELTestCase;

public class MessageAttachmentsTestCase
extends AbstractELTestCase {
    public MessageAttachmentsTestCase(AbstractELTestCase.Variant variant) {
        super(variant);
    }

    @Test
    public void inboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Assert.assertTrue((boolean)(this.evaluate("message.inboundAttachments", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToInboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.inboundAttachments='foo'", (MuleMessage)message);
    }

    @Test
    public void inboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", dataHandler);
        Assert.assertEquals((Object)dataHandler, (Object)this.evaluate("message.inboundAttachments['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToInboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", dataHandler);
        this.assertUnsupportedOperation("message.inboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
    }

    @Test
    public void assignValueToNewInboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertUnsupportedOperation("message.inboundAttachments['foo_new']=new DataHandler('bar','text/plain')", (MuleMessage)message);
    }

    @Test
    public void outboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Assert.assertTrue((boolean)(this.evaluate("message.outboundAttachments", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToOutboundAttachmentMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.outboundAttachments='foo'", (MuleMessage)message);
    }

    @Test
    public void outboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler dataHandler = (DataHandler)Mockito.mock(DataHandler.class);
        message.addOutboundAttachment("foo", dataHandler);
        Assert.assertEquals((Object)dataHandler, (Object)this.evaluate("message.outboundAttachments['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        this.evaluate("message.outboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundAttachment("foo").getContent());
    }

    @Test
    public void assignValueToNewOutboundAttachment() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundAttachments['foo']=new DataHandler('bar','text/plain')", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundAttachment("foo").getContent());
    }

    @Test
    public void inboundClear() throws Exception {
        this.assertUnsupportedOperation("message.inboundAttachments.clear()", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void inboundSize() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addInboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addInboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.inboundAttachments.size()", (MuleMessage)message));
    }

    @Test
    public void inboundKeySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addInboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addInboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.inboundAttachments.keySet().toArray()[0]", (MuleMessage)message));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.inboundAttachments.keySet().toArray()[1]", (MuleMessage)message));
    }

    @Test
    public void inboundContainsKey() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addInboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundAttachments.containsKey('foo')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundAttachments.containsKey('bar')", (MuleMessage)message)));
    }

    @Test
    public void inboundContainsValue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", valA);
        message.setPayload((Object)valA);
        Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundAttachments.containsValue(payload)", (MuleMessage)message)));
        Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundAttachments.containsValue('bar')", (MuleMessage)message)));
    }

    @Test
    public void inboundEntrySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        DataHandler valB = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", valA);
        message.addInboundAttachment("bar", valB);
        Set entrySet = (Set)this.evaluate("message.inboundAttachments.entrySet()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)valA));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)valB));
    }

    @Test
    public void inboundValues() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        DataHandler valB = (DataHandler)Mockito.mock(DataHandler.class);
        message.addInboundAttachment("foo", valA);
        message.addInboundAttachment("bar", valB);
        Collection values = (Collection)this.evaluate("message.inboundAttachments.values()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains(valA);
        values.contains(valB);
    }

    @Test
    public void inboundIsEmpty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundAttachments.isEmpty()", (MuleMessage)message)));
        message.addInboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addInboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundAttachments.isEmpty()", (MuleMessage)message)));
    }

    @Test
    public void inboundPutAll() throws Exception {
        this.assertUnsupportedOperation("message.inboundAttachments.putAll(['foo': new DataHandler(new URL('http://val1')),'bar': new DataHandler(new URL('http://val2'))])", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void inboundRemove() throws Exception {
        this.assertUnsupportedOperation("message.inboundAttachments.remove('foo')", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void outboundClear() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addOutboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        this.evaluate("message.outboundAttachments.clear()", (MuleMessage)message);
        Assert.assertEquals((long)0L, (long)message.getOutboundAttachmentNames().size());
    }

    @Test
    public void outboundSize() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addOutboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.outboundAttachments.size()", (MuleMessage)message));
    }

    @Test
    public void outboundKeySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addOutboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.outboundAttachments.keySet().toArray()[0]", (MuleMessage)message));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.outboundAttachments.keySet().toArray()[1]", (MuleMessage)message));
    }

    @Test
    public void outboundContainsKey() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundAttachments.containsKey('foo')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundAttachments.containsKey('bar')", (MuleMessage)message)));
    }

    @Test
    public void outboundContainsValue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        message.addOutboundAttachment("foo", valA);
        message.setPayload((Object)valA);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundAttachments.containsValue(payload)", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundAttachments.containsValue('bar')", (MuleMessage)message)));
    }

    @Test
    public void outboundEntrySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        DataHandler valB = (DataHandler)Mockito.mock(DataHandler.class);
        message.addOutboundAttachment("foo", valA);
        message.addOutboundAttachment("bar", valB);
        Set entrySet = (Set)this.evaluate("message.outboundAttachments.entrySet()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)valA));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)valB));
    }

    @Test
    public void outboundValues() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DataHandler valA = (DataHandler)Mockito.mock(DataHandler.class);
        DataHandler valB = (DataHandler)Mockito.mock(DataHandler.class);
        message.addOutboundAttachment("foo", valA);
        message.addOutboundAttachment("bar", valB);
        Collection values = (Collection)this.evaluate("message.outboundAttachments.values()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains(valA);
        values.contains(valB);
    }

    @Test
    public void outboundIsEmpty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundAttachments.isEmpty()", (MuleMessage)message)));
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        message.addOutboundAttachment("bar", (DataHandler)Mockito.mock(DataHandler.class));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundAttachments.isEmpty()", (MuleMessage)message)));
    }

    @Test
    public void outboundPutAll() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundAttachments.putAll(['foo': new DataHandler(new URL('http://val1')),'bar': new DataHandler(new URL('http://val2'))])", (MuleMessage)message);
        Assert.assertEquals(DataHandler.class, ((DataHandler)this.evaluate("message.outboundAttachments['foo']", (MuleMessage)message)).getClass());
        Assert.assertEquals(DataHandler.class, this.evaluate("message.outboundAttachments['bar']", (MuleMessage)message).getClass());
    }

    @Test
    public void outboundInboundRemove() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.addOutboundAttachment("foo", (DataHandler)Mockito.mock(DataHandler.class));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundAttachments.isEmpty()", (MuleMessage)message)));
        this.evaluate("message.outboundAttachments.remove('foo')", (MuleMessage)message);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundAttachments.isEmpty()", (MuleMessage)message)));
    }
}

