/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.function;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.el.context.MessageContext;
import org.mule.el.function.RegexExpressionLanguageFuntion;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;

@SmallTest
public class RegexExpressionLanguageFunctionTestCase
extends AbstractMuleTestCase {
    protected ExpressionExecutor<MVELExpressionLanguageContext> expressionExecutor;
    protected MVELExpressionLanguageContext context;
    protected RegexExpressionLanguageFuntion regexFuntion;

    @Before
    public void setup() throws InitialisationException {
        ParserContext parserContext = new ParserContext();
        this.expressionExecutor = new MVELExpressionExecutor(parserContext);
        this.context = new MVELExpressionLanguageContext(parserContext, (MuleContext)Mockito.mock(MuleContext.class));
        this.regexFuntion = new RegexExpressionLanguageFuntion();
        this.context.declareFunction("regex", (ExpressionLanguageFunction)this.regexFuntion);
    }

    @Test
    public void testReturnNullWhenDoesNotMatches() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        Object result = this.regexFuntion.call(new Object[]{"'TESTw+TEST'"}, (ExpressionLanguageContext)this.context);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReturnNullWhenDoesNotMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        Object result = this.expressionExecutor.execute("regex('TESTw+TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefined() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.regexFuntion.call(new Object[]{"TEST\\w+TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.expressionExecutor.execute("regex('TEST\\\\w+TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsMatchedValueIfCaptureGroupDefined() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.regexFuntion.call(new Object[]{"TEST(\\w+)TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    @Test
    public void testReturnsMatchedValueIfCaptureGroupDefinedMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        Object result = this.expressionExecutor.execute("regex('TEST(\\\\w+)TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"foo", (Object)result);
    }

    @Test
    public void testReturnsMultipleValuesIfMultipleCaptureGroupDefine() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTESTbar");
        Object result = this.regexFuntion.call(new Object[]{"TEST(\\w+)TEST(\\w+)"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)(result instanceof String[]));
        String[] values = (String[])result;
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"foo", (Object)values[0]);
        Assert.assertEquals((Object)"bar", (Object)values[1]);
    }

    @Test
    public void testReturnsMultipleValuesIfMultipleCaptureGroupDefineMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTESTbar");
        Object result = this.expressionExecutor.execute("regex('TEST(\\\\w+)TEST(\\\\w+)')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)(result instanceof String[]));
        String[] values = (String[])result;
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"foo", (Object)values[0]);
        Assert.assertEquals((Object)"bar", (Object)values[1]);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextArgument() throws Exception {
        Object result = this.regexFuntion.call(new Object[]{"TEST\\w+TEST", "TESTfooTEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextArgumentMVEL() throws Exception {
        Object result = this.expressionExecutor.execute("regex('TEST\\\\w+TEST','TESTfooTEST')", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextAndFlagsArgument() throws Exception {
        Object result = this.regexFuntion.call(new Object[]{"test\\w+test", "TESTfooTEST", 2}, (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test
    public void testReturnsPayloadWhenMatchesIfNoCaptureGroupDefinedTextAndFlagsArgumentMVEL() throws Exception {
        Object result = this.expressionExecutor.execute("regex('test\\\\w+test','TESTfooTEST', java.util.regex.Pattern.CASE_INSENSITIVE)", (ExpressionLanguageContext)this.context);
        Assert.assertEquals((Object)"TESTfooTEST", (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullRegex() throws Exception {
        this.regexFuntion.call(new Object[]{null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullRegexMVEL() throws Exception {
        this.expressionExecutor.execute("regex(null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringRegex() throws Exception {
        this.regexFuntion.call(new Object[]{new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringRegexMVEL() throws Exception {
        this.expressionExecutor.execute("regex(new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullText() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullTextMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST',null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringText() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST',new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonIntFlags() throws Exception {
        this.regexFuntion.call(new Object[]{"TESTw+TEST", "text", "foo"}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonIntFlagsMVEL() throws Exception {
        this.expressionExecutor.execute("regex('TESTw+TEST','text','foo')", (ExpressionLanguageContext)this.context);
    }

    protected void addMessageToContextWithPayload(String payload) throws TransformerException {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload((Class)Mockito.any(Class.class))).thenReturn((Object)payload);
        this.context.addFinalVariable("message", (Object)new MessageContext(message));
    }
}

