/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.UrlEndpointURIBuilder;
import org.mule.endpoint.UserInfoEndpointURIBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class EndpointURIBuilderTestCase
extends AbstractMuleTestCase {
    private static final String PLAIN_USERNAME_URI = "test://user:secret@theHost:42/path?key=value#fragment";
    private static final String EXPECTED_PLAIN_URI_STRING = "test://user:****@theHost:42/path?key=value#fragment";
    private static final String USERNAME_WITH_AT_SIGN_URI = "test://user%40host:secret@theHost:42/path?key=value#fragment";
    private static final String EXPECTED_AT_SIGN_URI_STRING = "test://user%40host:****@theHost:42/path?key=value#fragment";
    private MuleContext unusedMuleContext = null;

    @Test
    public void testGetPropertiesForURI() throws MalformedEndpointException, URISyntaxException {
        UrlEndpointURIBuilder endpointURIBuilder = new UrlEndpointURIBuilder();
        endpointURIBuilder.build(new URI("ftp://test%25user:test@192.168.1.12:21"), this.unusedMuleContext);
        Assert.assertEquals((Object)"test%user:test", (Object)endpointURIBuilder.userInfo);
    }

    @Test
    public void testUrlEndpointBuilderPasswordMasking() throws Exception {
        UrlEndpointURIBuilder builder = new UrlEndpointURIBuilder();
        this.checkUriWithPlainUsername((EndpointURIBuilder)builder);
    }

    @Test
    public void testUrlEndpointBuilderPasswordMaskingWithAtSign() throws Exception {
        UrlEndpointURIBuilder builder = new UrlEndpointURIBuilder();
        this.checkUriWithUsernameContainingAtSign((EndpointURIBuilder)builder);
    }

    @Test
    public void testUserInfoEndpointBuilderPasswordMasking() throws Exception {
        UserInfoEndpointURIBuilder builder = new UserInfoEndpointURIBuilder();
        this.checkUriWithPlainUsername((EndpointURIBuilder)builder);
    }

    @Test
    public void testUserInfoEndpointBuilderPasswordMaskingWithAtSign() throws Exception {
        UserInfoEndpointURIBuilder builder = new UserInfoEndpointURIBuilder();
        this.checkUriWithUsernameContainingAtSign((EndpointURIBuilder)builder);
    }

    private void checkUriWithPlainUsername(EndpointURIBuilder builder) throws Exception {
        URI inputUri = new URI(PLAIN_USERNAME_URI);
        EndpointURI uri = builder.build(inputUri, this.unusedMuleContext);
        Assert.assertEquals((Object)"user", (Object)uri.getUser());
        this.assertUriParts(uri);
        Assert.assertEquals((Object)EXPECTED_PLAIN_URI_STRING, (Object)uri.toString());
    }

    private void checkUriWithUsernameContainingAtSign(EndpointURIBuilder builder) throws Exception {
        URI inputUri = new URI(USERNAME_WITH_AT_SIGN_URI);
        EndpointURI uri = builder.build(inputUri, this.unusedMuleContext);
        Assert.assertEquals((Object)"user@host", (Object)uri.getUser());
        this.assertUriParts(uri);
        Assert.assertEquals((Object)EXPECTED_AT_SIGN_URI_STRING, (Object)uri.toString());
    }

    private void assertUriParts(EndpointURI uri) {
        Assert.assertEquals((Object)"secret", (Object)uri.getPassword());
        Assert.assertEquals((Object)"theHost", (Object)uri.getHost());
        Assert.assertEquals((long)42L, (long)uri.getPort());
        Assert.assertEquals((Object)"/path", (Object)uri.getPath());
        Assert.assertEquals((Object)"key=value", (Object)uri.getQuery());
    }
}

