/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.QueueProfile;
import org.mule.construct.Flow;
import org.mule.management.stats.QueueStatistics;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.AsyncInterceptingMessageProcessorTestCase;
import org.mule.processor.AsyncWorkListener;
import org.mule.processor.SedaStageInterceptingMessageProcessor;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.util.concurrent.Latch;

public class SedaStageInterceptingMessageProcessorTestCase
extends AsyncInterceptingMessageProcessorTestCase
implements ExceptionListener {
    QueueProfile queueProfile = null;
    int queueTimeout;
    QueueStatistics queueStatistics;
    TestLifeCycleState lifeCycleState;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueProfile = QueueProfile.newInstancePersistingToDefaultMemoryQueueStore((MuleContext)muleContext);
        this.queueStatistics = new TestQueueStatistics();
        this.queueTimeout = muleContext.getConfiguration().getDefaultQueueTimeout();
        this.lifeCycleState = new TestLifeCycleState();
        super.doSetUp();
        ((Initialisable)this.messageProcessor).initialise();
        this.messageProcessor.start();
        this.lifeCycleState.start();
    }

    @Override
    protected boolean isStartContext() {
        return false;
    }

    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.messageProcessor.stop();
        this.lifeCycleState.stop();
        this.lifeCycleState.dispose();
    }

    @Test
    public void testProcessOneWayThreadWaitTimeout() throws Exception {
        int threadTimeout = 20;
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(muleContext.getDefaultThreadingProfile());
        threadingProfile.setThreadWaitTimeout(20L);
        threadingProfile.setMaxThreadsActive(3);
        threadingProfile.setPoolExhaustedAction(0);
        threadingProfile.setMuleContext(muleContext);
        MessageProcessor mockListener = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)mockListener.process((MuleEvent)Matchers.any())).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(40L);
                return (MuleEvent)invocation.getArguments()[0];
            }
        });
        SedaStageInterceptingMessageProcessor sedaStageInterceptingMessageProcessor = new SedaStageInterceptingMessageProcessor("testProcessOneWayThreadWaitTimeout", "testProcessOneWayThreadWaitTimeout", this.queueProfile, this.queueTimeout, (ThreadingProfile)threadingProfile, this.queueStatistics, muleContext);
        sedaStageInterceptingMessageProcessor.setListener(mockListener);
        sedaStageInterceptingMessageProcessor.initialise();
        sedaStageInterceptingMessageProcessor.start();
        MessagingExceptionHandler exceptionHandler = (MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new AsynchronousProcessingStrategy());
        final MuleEvent event = SedaStageInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", (FlowConstruct)flow, MessageExchangePattern.ONE_WAY);
        for (int i = 0; i < 3; ++i) {
            sedaStageInterceptingMessageProcessor.process(event);
        }
        ArgumentMatcher<MuleEvent> notSameEvent = new ArgumentMatcher<MuleEvent>(){

            public boolean matches(Object argument) {
                return !argument.equals(event);
            }
        };
        ((MessageProcessor)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.timeout((int)5000).times(2))).process((MuleEvent)Matchers.argThat((Matcher)notSameEvent));
        ((MessagingExceptionHandler)Mockito.verify((Object)exceptionHandler, (VerificationMode)Mockito.timeout((int)5000).times(1))).handleException((Exception)Matchers.any(), (MuleEvent)Matchers.argThat((Matcher)notSameEvent));
    }

    @Test
    public void testProcessOneWayWithException() throws Exception {
        final Latch latch = new Latch();
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(muleContext.getDefaultThreadingProfile());
        threadingProfile.setMuleContext(muleContext);
        MessageProcessor mockListener = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)mockListener.process((MuleEvent)Matchers.any())).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                latch.countDown();
                throw new RuntimeException();
            }
        });
        SedaStageInterceptingMessageProcessor sedaStageInterceptingMessageProcessor = new SedaStageInterceptingMessageProcessor("testProcessOneWayWithException", "testProcessOneWayWithException", this.queueProfile, this.queueTimeout, (ThreadingProfile)threadingProfile, this.queueStatistics, muleContext);
        sedaStageInterceptingMessageProcessor.setListener(mockListener);
        sedaStageInterceptingMessageProcessor.initialise();
        sedaStageInterceptingMessageProcessor.start();
        MessagingExceptionHandler exceptionHandler = (MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new AsynchronousProcessingStrategy());
        final MuleEvent event = SedaStageInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", (FlowConstruct)flow, MessageExchangePattern.ONE_WAY);
        sedaStageInterceptingMessageProcessor.process(event);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
        ArgumentMatcher<MuleEvent> notSameEvent = new ArgumentMatcher<MuleEvent>(){

            public boolean matches(Object argument) {
                return !argument.equals(event);
            }
        };
        ((MessageProcessor)Mockito.verify((Object)mockListener, (VerificationMode)Mockito.timeout((int)5000).times(1))).process((MuleEvent)Matchers.argThat((Matcher)notSameEvent));
        ((MessagingExceptionHandler)Mockito.verify((Object)exceptionHandler, (VerificationMode)Mockito.timeout((int)5000).times(1))).handleException((Exception)Matchers.any(), (MuleEvent)Matchers.argThat((Matcher)notSameEvent));
    }

    @Test(expected=MessagingException.class)
    public void testProcessOneWayNoThreadingWithException() throws Exception {
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(muleContext.getDefaultThreadingProfile());
        threadingProfile.setDoThreading(false);
        threadingProfile.setMuleContext(muleContext);
        MessageProcessor mockListener = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        Mockito.when((Object)mockListener.process((MuleEvent)Matchers.any())).thenThrow(new Throwable[]{new RuntimeException()});
        SedaStageInterceptingMessageProcessor sedaStageInterceptingMessageProcessor = new SedaStageInterceptingMessageProcessor("testProcessOneWayNoThreadingWithException", "testProcessOneWayNoThreadingWithException", this.queueProfile, this.queueTimeout, (ThreadingProfile)threadingProfile, this.queueStatistics, muleContext);
        sedaStageInterceptingMessageProcessor.setListener(mockListener);
        sedaStageInterceptingMessageProcessor.initialise();
        sedaStageInterceptingMessageProcessor.start();
        MessagingExceptionHandler exceptionHandler = (MessagingExceptionHandler)Mockito.mock(MessagingExceptionHandler.class);
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getExceptionListener()).thenReturn((Object)exceptionHandler);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new AsynchronousProcessingStrategy());
        MuleEvent event = SedaStageInterceptingMessageProcessorTestCase.getTestEvent((Object)"Test Message", (FlowConstruct)flow, MessageExchangePattern.ONE_WAY);
        sedaStageInterceptingMessageProcessor.process(event);
    }

    @Override
    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(MessageProcessor listener) throws Exception {
        SedaStageInterceptingMessageProcessor mp = new SedaStageInterceptingMessageProcessor("name", "name", this.queueProfile, this.queueTimeout, muleContext.getDefaultThreadingProfile(), this.queueStatistics, muleContext);
        mp.setMuleContext(muleContext);
        mp.setListener(listener);
        return mp;
    }

    @Test
    public void testSpiWorkThrowableHandling() throws Exception {
        try {
            new AsyncWorkListener((MessageProcessor)this.getSensingNullMessageProcessor()).handleWorkException(this.getTestWorkEvent(), "workRejected");
        }
        catch (MuleRuntimeException mrex) {
            Assert.assertNotNull((Object)((Object)mrex));
            Assert.assertTrue((mrex.getCause().getClass() == Throwable.class ? 1 : 0) != 0);
            Assert.assertEquals((Object)"testThrowable", (Object)mrex.getCause().getMessage());
        }
    }

    private WorkEvent getTestWorkEvent() {
        return new WorkEvent((Object)this, 2, this.getTestWork(), new WorkException(new Throwable("testThrowable")));
    }

    private Work getTestWork() {
        return new Work(){

            public void release() {
            }

            public void run() {
            }
        };
    }

    class TestLifeCycleState
    implements LifecycleState,
    Lifecycle {
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(true);
        AtomicBoolean disposed = new AtomicBoolean(false);
        AtomicBoolean initialised = new AtomicBoolean(false);
        AtomicBoolean paused = new AtomicBoolean(false);

        TestLifeCycleState() {
        }

        public boolean isDisposed() {
            return this.disposed.get();
        }

        public boolean isDisposing() {
            return false;
        }

        public boolean isInitialised() {
            return this.initialised.get();
        }

        public boolean isInitialising() {
            return false;
        }

        public boolean isPhaseComplete(String phase) {
            if ("pause".equals(phase)) {
                return this.paused.get();
            }
            return false;
        }

        public boolean isPhaseExecuting(String phase) {
            return false;
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public boolean isStarting() {
            return false;
        }

        public boolean isStopped() {
            return this.stopped.get();
        }

        public boolean isStopping() {
            return false;
        }

        public void initialise() throws InitialisationException {
            this.initialised.set(true);
        }

        public void start() throws MuleException {
            this.initialised.set(false);
            this.stopped.set(false);
            this.started.set(true);
        }

        public void stop() throws MuleException {
            this.started.set(false);
            this.stopped.set(true);
        }

        public void dispose() {
            this.stopped.set(true);
            this.disposed.set(true);
        }

        public boolean isValidTransition(String phase) {
            return false;
        }
    }

    class TestQueueStatistics
    implements QueueStatistics {
        int incCount;
        int decCount;

        TestQueueStatistics() {
        }

        public void decQueuedEvent() {
            ++this.decCount;
        }

        public void incQueuedEvent() {
            ++this.incCount;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

