/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.routing.outbound.SequenceRouter;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SequenceRouterTestCase
extends AbstractMuleContextTestCase {
    private MuleSession session;
    private SequenceRouter router;
    private OutboundEndpoint mockEndpoint1;
    private OutboundEndpoint mockEndpoint2;

    @Override
    protected void doSetUp() throws Exception {
        this.session = (MuleSession)Mockito.mock(MuleSession.class);
        OutboundEndpoint endpoint1 = SequenceRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        this.mockEndpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = SequenceRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        this.mockEndpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        this.router = this.createObject(SequenceRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(this.mockEndpoint1);
        endpoints.add(this.mockEndpoint2);
        this.router.setRoutes(endpoints);
    }

    @Test
    public void testSyncEndpointsOk() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)this.mockEndpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((long)2L, (long)((MuleMessageCollection)resultMessage).size());
    }

    @Test
    public void testSyncEndpointsWithFirstOneFailing() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent eventWithNullMessage = new OutboundRoutingTestEvent(null, null, muleContext);
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(eventWithNullMessage));
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)result);
    }

    @Test
    public void testSyncEndpointsWithLastOneFailing() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        OutboundRoutingTestEvent eventWithNullMessage = new OutboundRoutingTestEvent(null, null, muleContext);
        Mockito.when((Object)this.mockEndpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)this.mockEndpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(eventWithNullMessage));
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, this.session, muleContext));
        Assert.assertNotNull((Object)result);
    }
}

