/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.MapUtils;
import org.mule.util.PropertiesUtils;

@SmallTest
public class PropertiesUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testRemoveNameSpacePrefix() {
        String temp = "this.is.a.namespace";
        String result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"namespace", (Object)result);
        temp = "this.namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"namespace", (Object)result);
        temp = "namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"namespace", (Object)result);
        temp = "this_is-a-namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"this_is-a-namespace", (Object)result);
    }

    @Test
    public void testRemoveXMLNameSpacePrefix() {
        String temp = "j:namespace";
        String result = PropertiesUtils.removeXmlNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"namespace", (Object)result);
        temp = "this-namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"this-namespace", (Object)result);
        temp = "namespace";
        result = PropertiesUtils.removeNamespacePrefix((String)temp);
        Assert.assertEquals((Object)"namespace", (Object)result);
    }

    @Test
    public void testRemoveNamespaces() throws Exception {
        Map<String, String> props = new HashMap<String, String>();
        props.put("blah.booleanProperty", "true");
        props.put("blah.blah.doubleProperty", NumberFormat.getInstance().format(0.124));
        props.put("blah.blah.Blah.intProperty", "14");
        props.put("longProperty", "999999999");
        props.put("3456.stringProperty", "string");
        props = PropertiesUtils.removeNamespaces(props);
        Assert.assertTrue((boolean)MapUtils.getBooleanValue(props, (Object)"booleanProperty", (boolean)false));
        Assert.assertEquals((double)0.124, (double)0.0, (double)MapUtils.getDoubleValue(props, (Object)"doubleProperty", (double)0.0));
        Assert.assertEquals((long)14L, (long)MapUtils.getIntValue(props, (Object)"intProperty", (int)0));
        Assert.assertEquals((double)9.99999999E8, (double)0.0, (double)MapUtils.getLongValue(props, (Object)"longProperty", (long)0L));
        Assert.assertEquals((Object)"string", (Object)MapUtils.getString(props, (Object)"stringProperty", (String)""));
    }

    @Test
    public void testMaskedProperties() {
        Assert.assertNull((Object)PropertiesUtils.maskedPropertyValue(null));
        Assert.assertNull((Object)PropertiesUtils.maskedPropertyValue((Map.Entry)new DefaultMapEntry(null, (Object)"value")));
        Assert.assertNull((Object)PropertiesUtils.maskedPropertyValue((Map.Entry)new DefaultMapEntry((Object)"key", null)));
        DefaultMapEntry property = new DefaultMapEntry((Object)"secretname", (Object)"secret");
        Assert.assertTrue((boolean)"secret".equals(PropertiesUtils.maskedPropertyValue((Map.Entry)property)));
        PropertiesUtils.registerMaskedPropertyName((String)"secretname");
        String masked = PropertiesUtils.maskedPropertyValue((Map.Entry)property);
        Assert.assertFalse((boolean)"secret".equals(masked));
        Assert.assertTrue((boolean)masked.startsWith("*"));
    }

    @Test
    public void testLoadAllProperties() {
        Properties properties = PropertiesUtils.loadAllProperties((String)"META-INF/services/org/mule/config/mule-exception-codes.properties", (ClassLoader)this.getClass().getClassLoader());
        Assert.assertThat((Object)((String)properties.get("java.lang.IllegalArgumentException")), (Matcher)Is.is((Object)"104000"));
        Assert.assertThat((Object)((String)properties.get("org.mule.api.MuleException")), (Matcher)Is.is((Object)"10000"));
    }

    @Test
    public void testLoadAllPropertiesNoFile() {
        Properties properties = PropertiesUtils.loadAllProperties((String)"META-INF/services/org/mule/config/mule-non-existent.properties", (ClassLoader)this.getClass().getClassLoader());
        Assert.assertThat((Object)properties, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)properties.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testLoadAllPropertiesEmptyFile() {
        Properties properties = PropertiesUtils.loadAllProperties((String)"META-INF/services/org/mule/config/mule-empty.properties", (ClassLoader)this.getClass().getClassLoader());
        Assert.assertThat((Object)properties, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)properties.isEmpty(), (Matcher)Is.is((Object)true));
    }
}

