/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.net.URI;
import java.util.Properties;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.UserInfoEndpointURIBuilder;
import org.mule.transport.xmpp.XmppMessageType;
import org.mule.transport.xmpp.i18n.XmppMessages;

public class XmppEndpointURIBuilder
extends UserInfoEndpointURIBuilder {
    protected void setEndpoint(URI uri, Properties props) throws MalformedEndpointException {
        this.checkXmppMessageType(uri);
        this.checkRecipient(uri);
        super.setEndpoint(uri, props);
    }

    private void checkXmppMessageType(URI uri) throws MalformedEndpointException {
        String host = uri.getHost();
        if (host.length() == 0) {
            throw new MalformedEndpointException(XmppMessages.noMessageTypeInUri(), uri.toString());
        }
        try {
            XmppMessageType.valueOf(host);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEndpointException(XmppMessages.invalidMessageTypeInUri(), uri.toString());
        }
    }

    private void checkRecipient(URI uri) throws MalformedEndpointException {
        if (this.isDynamic(uri)) {
            return;
        }
        if (uri.getPath().length() == 0) {
            throw new MalformedEndpointException(XmppMessages.noRecipientInUri(), uri.toString());
        }
    }

    private boolean isDynamic(URI uri) {
        String host = uri.getHost();
        return XmppMessageType.dynamic.name().equals(host);
    }
}

