/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizingInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractAuthorizingInInterceptor.class);
    private static final String ALL_ROLES = "*";

    public AbstractAuthorizingInInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) throws Fault {
        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
        if (sc == null) {
            return;
        }
        Method method = this.getTargetMethod(message);
        if (this.authorize(sc, method)) {
            return;
        }
        throw new AccessDeniedException("Unauthorized");
    }

    protected Method getTargetMethod(Message m) {
        BindingOperationInfo bop = (BindingOperationInfo)m.getExchange().get(BindingOperationInfo.class);
        if (bop != null) {
            MethodDispatcher md = (MethodDispatcher)((Service)m.getExchange().get(Service.class)).get((Object)MethodDispatcher.class.getName());
            return md.getMethod(bop);
        }
        Method method = (Method)m.get((Object)"org.apache.cxf.resource.method");
        if (method != null) {
            return method;
        }
        throw new AccessDeniedException("Method is not available : Unauthorized");
    }

    protected boolean authorize(SecurityContext sc, Method method) {
        List<String> expectedRoles = this.getExpectedRoles(method);
        if (expectedRoles.isEmpty()) {
            List<String> denyRoles = this.getDenyRoles(method);
            return denyRoles.isEmpty() ? true : this.isUserInRole(sc, denyRoles, true);
        }
        if (this.isUserInRole(sc, expectedRoles, false)) {
            return true;
        }
        if (sc.getUserPrincipal() != null) {
            LOG.fine(sc.getUserPrincipal().getName() + " is not authorized");
        }
        return false;
    }

    protected boolean isUserInRole(SecurityContext sc, List<String> roles, boolean deny) {
        if (roles.size() == 1 && ALL_ROLES.equals(roles.get(0))) {
            return !deny;
        }
        for (String role : roles) {
            if (!sc.isUserInRole(role)) continue;
            return !deny;
        }
        return deny;
    }

    protected abstract List<String> getExpectedRoles(Method var1);

    protected List<String> getDenyRoles(Method method) {
        return Collections.emptyList();
    }
}

