/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.transport.NullPayload;
import org.mule.transport.http.components.ResourceNotFoundException;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class StaticResourceMessageProcessor
implements MessageProcessor,
Initialisable {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String resourceBase;
    private String defaultFile = "index.html";
    private MimetypesFileTypeMap mimeTypes;

    public void initialise() throws InitialisationException {
        this.mimeTypes = new MimetypesFileTypeMap();
        this.mimeTypes.addMimeTypes("text/javascript js");
        this.mimeTypes.addMimeTypes("text/css css");
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (StringUtils.isEmpty((String)this.resourceBase)) {
            throw new ConfigurationException(HttpMessages.noResourceBaseDefined());
        }
        String path = (String)event.getMessage().getInboundProperty("http.request.path");
        String contextPath = (String)event.getMessage().getInboundProperty("http.context.path");
        path = path.substring(contextPath.length());
        File file = new File(this.resourceBase + path);
        MuleEvent resultEvent = event;
        if (file.isDirectory() && path.endsWith("/")) {
            file = new File(this.resourceBase + path + this.defaultFile);
        } else if (file.isDirectory()) {
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(302));
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)0);
            resultEvent.getMessage().setOutboundProperty("Location", (Object)(event.getMessage().getInboundProperty("http.request.path") + "/"));
            return resultEvent;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimetype = this.mimeTypes.getContentType(file);
            if (mimetype == null) {
                mimetype = DEFAULT_MIME_TYPE;
            }
            resultEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)buffer, event.getMuleContext()), event);
            resultEvent.getMessage().setOutboundProperty("http.status", (Object)String.valueOf(200));
            resultEvent.getMessage().setOutboundProperty("Content-Type", (Object)mimetype);
            resultEvent.getMessage().setOutboundProperty("Content-Length", (Object)buffer.length);
        }
        catch (IOException e) {
            throw new ResourceNotFoundException(HttpMessages.fileNotFound(this.resourceBase + path), event);
        }
        return resultEvent;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getDefaultFile() {
        return this.defaultFile;
    }

    public void setDefaultFile(String defaultFile) {
        this.defaultFile = defaultFile;
    }
}

