/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.message.ds.StringDataSource;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.PatchMethod;
import org.mule.transport.http.StreamPayloadRequestEntity;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.util.IOUtils;
import org.mule.util.ObjectUtils;
import org.mule.util.SerializationUtils;

public class ObjectToHttpClientMethodRequest
extends AbstractMessageTransformer {
    public ObjectToHttpClientMethodRequest() {
        this.setReturnDataType(DataTypeFactory.create(HttpMethod.class));
        this.registerSourceType(DataTypeFactory.MULE_MESSAGE);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.create(OutputHandler.class));
        this.registerSourceType(DataTypeFactory.create(NullPayload.class));
        this.registerSourceType(DataTypeFactory.create(Map.class));
    }

    public Object transformMessage(MuleMessage msg, String outputEncoding) throws TransformerException {
        String method = this.detectHttpMethod(msg);
        try {
            HttpMethod httpMethod;
            if ("GET".equals(method)) {
                httpMethod = this.createGetMethod(msg, outputEncoding);
            } else if ("POST".equalsIgnoreCase(method)) {
                httpMethod = this.createPostMethod(msg, outputEncoding);
            } else if ("PUT".equalsIgnoreCase(method)) {
                httpMethod = this.createPutMethod(msg, outputEncoding);
            } else if ("DELETE".equalsIgnoreCase(method)) {
                httpMethod = this.createDeleteMethod(msg);
            } else if ("HEAD".equalsIgnoreCase(method)) {
                httpMethod = this.createHeadMethod(msg);
            } else if ("OPTIONS".equalsIgnoreCase(method)) {
                httpMethod = this.createOptionsMethod(msg);
            } else if ("TRACE".equalsIgnoreCase(method)) {
                httpMethod = this.createTraceMethod(msg);
            } else if ("PATCH".equalsIgnoreCase(method)) {
                httpMethod = this.createPatchMethod(msg);
            } else {
                throw new TransformerException(HttpMessages.unsupportedMethod(method));
            }
            HttpMethodParams params = (HttpMethodParams)msg.removeProperty("http.params", PropertyScope.OUTBOUND);
            if (params != null) {
                httpMethod.setParams(params);
            } else {
                String httpVersion = (String)msg.getOutboundProperty("http.version", (Object)"HTTP/1.1");
                if ("HTTP/1.0".equals(httpVersion)) {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_0);
                } else {
                    httpMethod.getParams().setVersion(HttpVersion.HTTP_1_1);
                }
            }
            this.setHeaders(httpMethod, msg);
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected String detectHttpMethod(MuleMessage msg) {
        String method = (String)msg.getOutboundProperty("http.method", null);
        if (method == null) {
            method = (String)msg.getInvocationProperty("http.method", (Object)"POST");
        }
        return method;
    }

    protected HttpMethod createGetMethod(MuleMessage msg, String outputEncoding) throws Exception {
        Object src = msg.getPayload();
        URI uri = this.getURI(msg);
        String query = uri.getRawQuery();
        GetMethod httpMethod = new GetMethod(uri.toString());
        String paramName = (String)msg.getOutboundProperty("http.get.body.param", null);
        if (paramName != null) {
            paramName = URLEncoder.encode(paramName, outputEncoding);
            Boolean encode = (Boolean)msg.getInvocationProperty("http.encode.paramvalue");
            if (encode == null) {
                encode = (Boolean)msg.getOutboundProperty("http.encode.paramvalue", (Object)true);
            }
            String paramValue = encode != false ? URLEncoder.encode(src.toString(), outputEncoding) : src.toString();
            if (!(src instanceof NullPayload) && !"".equals(src)) {
                query = query == null ? paramName + "=" + paramValue : query + "&" + paramName + "=" + paramValue;
            }
        }
        httpMethod.setQueryString(query);
        return httpMethod;
    }

    protected HttpMethod createPostMethod(MuleMessage msg, String outputEncoding) throws Exception {
        URI uri = this.getURI(msg);
        PostMethod postMethod = new PostMethod(uri.toString());
        String bodyParameterName = this.getBodyParameterName(msg);
        Object src = msg.getPayload();
        if (src instanceof Map) {
            for (Map.Entry entry : ((Map)src).entrySet()) {
                postMethod.addParameter(entry.getKey().toString(), entry.getValue().toString());
            }
        } else if (bodyParameterName != null) {
            postMethod.addParameter(bodyParameterName, src.toString());
        } else {
            this.setupEntityMethod(src, outputEncoding, msg, (EntityEnclosingMethod)postMethod);
        }
        this.checkForContentType(msg, (EntityEnclosingMethod)postMethod);
        return postMethod;
    }

    private void checkForContentType(MuleMessage msg, EntityEnclosingMethod method) {
        String outgoingContentType = (String)msg.getInvocationProperty("Content-Type");
        if (outgoingContentType != null) {
            method.setRequestHeader("Content-Type", outgoingContentType);
        }
    }

    protected String getBodyParameterName(MuleMessage message) {
        String bodyParameter = (String)message.getOutboundProperty("http.post.body.param");
        if (bodyParameter == null) {
            bodyParameter = (String)message.getInvocationProperty("http.post.body.param");
        }
        return bodyParameter;
    }

    protected HttpMethod createPutMethod(MuleMessage msg, String outputEncoding) throws Exception {
        URI uri = this.getURI(msg);
        PutMethod putMethod = new PutMethod(uri.toString());
        Object payload = msg.getPayload();
        this.setupEntityMethod(payload, outputEncoding, msg, (EntityEnclosingMethod)putMethod);
        this.checkForContentType(msg, (EntityEnclosingMethod)putMethod);
        return putMethod;
    }

    protected HttpMethod createDeleteMethod(MuleMessage message) throws Exception {
        URI uri = this.getURI(message);
        return new DeleteMethod(uri.toString());
    }

    protected HttpMethod createHeadMethod(MuleMessage message) throws Exception {
        URI uri = this.getURI(message);
        return new HeadMethod(uri.toString());
    }

    protected HttpMethod createOptionsMethod(MuleMessage message) throws Exception {
        URI uri = this.getURI(message);
        return new OptionsMethod(uri.toString());
    }

    protected HttpMethod createTraceMethod(MuleMessage message) throws Exception {
        URI uri = this.getURI(message);
        return new TraceMethod(uri.toString());
    }

    protected HttpMethod createPatchMethod(MuleMessage message) throws Exception {
        URI uri = this.getURI(message);
        return new PatchMethod(uri.toString());
    }

    protected URI getURI(MuleMessage message) throws URISyntaxException, TransformerException {
        String endpointAddress = (String)message.getOutboundProperty("MULE_ENDPOINT", null);
        if (endpointAddress == null) {
            throw new TransformerException(HttpMessages.eventPropertyNotSetCannotProcessRequest("MULE_ENDPOINT"), (Transformer)this);
        }
        return new URI(endpointAddress);
    }

    protected void setupEntityMethod(Object src, String encoding, MuleMessage msg, EntityEnclosingMethod postMethod) throws UnsupportedEncodingException, TransformerException {
        if (!(msg.getPayload() instanceof NullPayload)) {
            String httpVersion;
            String outboundMimeType = (String)msg.getProperty("Content-Type", PropertyScope.OUTBOUND);
            if (outboundMimeType == null) {
                String string = outboundMimeType = this.getEndpoint() != null ? this.getEndpoint().getMimeType() : null;
            }
            if (outboundMimeType == null) {
                outboundMimeType = "text/plain";
                this.logger.info((Object)("Content-Type not set on outgoing request, defaulting to: " + outboundMimeType));
            }
            if (encoding != null && !"UTF-8".equals(encoding.toUpperCase()) && outboundMimeType.indexOf("charset") == -1) {
                outboundMimeType = outboundMimeType + "; charset=" + encoding;
            }
            if ("HTTP/1.0".equals(httpVersion = (String)msg.getOutboundProperty("http.version", (Object)"HTTP/1.1"))) {
                try {
                    src = msg.getPayloadAsBytes();
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            if (msg.getOutboundAttachmentNames() != null && msg.getOutboundAttachmentNames().size() > 0) {
                try {
                    postMethod.setRequestEntity((RequestEntity)this.createMultiPart(msg, postMethod));
                    return;
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            if (src instanceof String) {
                postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(src.toString(), outboundMimeType, encoding));
                return;
            }
            if (src instanceof InputStream) {
                postMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)src, outboundMimeType));
            } else if (src instanceof byte[]) {
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity((byte[])src, outboundMimeType));
            } else if (src instanceof OutputHandler) {
                MuleEvent event = RequestContext.getEvent();
                postMethod.setRequestEntity((RequestEntity)new StreamPayloadRequestEntity((OutputHandler)src, event));
            } else {
                byte[] buffer = SerializationUtils.serialize((Serializable)((Serializable)src));
                postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(buffer, outboundMimeType));
            }
        } else if (msg.getOutboundAttachmentNames() != null && msg.getOutboundAttachmentNames().size() > 0) {
            try {
                postMethod.setRequestEntity((RequestEntity)this.createMultiPart(msg, postMethod));
            }
            catch (Exception e) {
                throw new TransformerException((Transformer)this, (Throwable)e);
            }
        }
    }

    protected void setHeaders(HttpMethod httpMethod, MuleMessage msg) throws TransformerException {
        for (String headerName : msg.getOutboundPropertyNames()) {
            String headerValue = ObjectUtils.getString((Object)msg.getOutboundProperty(headerName), null);
            if (headerName.startsWith("MULE_")) {
                headerName = new StringBuffer(30).append("X-").append(headerName).toString();
                httpMethod.addRequestHeader(headerName, headerValue);
                continue;
            }
            if (HttpConstants.RESPONSE_HEADER_NAMES.containsKey(headerName) || HttpConnector.HTTP_INBOUND_PROPERTIES.contains(headerName) || "cookies".equals(headerName)) continue;
            httpMethod.addRequestHeader(headerName, headerValue);
        }
    }

    protected MultipartRequestEntity createMultiPart(MuleMessage msg, EntityEnclosingMethod method) throws Exception {
        Part[] parts;
        int i = 0;
        if (msg.getPayload() instanceof NullPayload) {
            parts = new Part[msg.getOutboundAttachmentNames().size()];
        } else {
            parts = new Part[msg.getOutboundAttachmentNames().size() + 1];
            parts[i++] = new FilePart("payload", (PartSource)new ByteArrayPartSource("payload", msg.getPayloadAsBytes()));
        }
        Iterator iterator = msg.getOutboundAttachmentNames().iterator();
        while (iterator.hasNext()) {
            String attachmentNames;
            String fileName = attachmentNames = (String)iterator.next();
            DataHandler dh = msg.getOutboundAttachment(attachmentNames);
            if (dh.getDataSource() instanceof StringDataSource) {
                StringDataSource ds = (StringDataSource)dh.getDataSource();
                parts[i] = new StringPart(ds.getName(), IOUtils.toString((InputStream)ds.getInputStream()));
            } else {
                int x;
                if (dh.getDataSource() instanceof FileDataSource) {
                    fileName = ((FileDataSource)dh.getDataSource()).getFile().getName();
                } else if (dh.getDataSource() instanceof URLDataSource && (x = (fileName = ((URLDataSource)dh.getDataSource()).getURL().getFile()).lastIndexOf("/")) > -1) {
                    fileName = fileName.substring(x + 1);
                }
                parts[i] = new FilePart(dh.getName(), (PartSource)new ByteArrayPartSource(fileName, IOUtils.toByteArray((InputStream)dh.getInputStream())), dh.getContentType(), null);
            }
            ++i;
        }
        return new MultipartRequestEntity(parts, method.getParams());
    }
}

