/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.mule.common.FailureType;
import org.mule.common.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResult<T>
implements Result<T> {
    private T obj;
    private Result.Status status;
    private String message;
    private FailureType failureType;
    private String stacktrace;

    public DefaultResult(T obj) {
        this(obj, Result.Status.SUCCESS);
    }

    public DefaultResult(T obj, Result.Status status) {
        this(obj, status, "");
    }

    public DefaultResult(T obj, Result.Status status, String message) {
        this(obj, status, message, Result.Status.FAILURE.equals((Object)status) ? FailureType.UNSPECIFIED : null, null);
    }

    public DefaultResult(T obj, Result.Status status, String message, FailureType failureType, Throwable throwable) {
        this.obj = obj;
        this.status = status;
        this.message = message;
        this.failureType = failureType;
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.stacktrace = sw.toString();
        } else {
            this.stacktrace = null;
        }
    }

    @Override
    public T get() {
        return this.obj;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Result.Status getStatus() {
        return this.status;
    }

    @Override
    public FailureType getFailureType() {
        return this.failureType;
    }

    @Override
    public String getStacktrace() {
        return this.stacktrace;
    }
}

