/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Logger;
import mx4j.remote.ProviderHelper;

public class ProviderFactory
extends ProviderHelper {
    public static JMXConnectorProvider newJMXConnectorProvider(JMXServiceURL url, Map env) throws IOException {
        String protocol = ProviderFactory.normalizeProtocol(url.getProtocol());
        String providerPackages = ProviderFactory.findProviderPackageList(env, "jmx.remote.protocol.provider.pkgs");
        ClassLoader classLoader = ProviderFactory.findProviderClassLoader(env, "jmx.remote.protocol.provider.class.loader");
        JMXConnectorProvider provider = (JMXConnectorProvider)ProviderFactory.loadProvider(providerPackages, protocol, "ClientProvider", classLoader);
        return provider;
    }

    public static JMXConnectorServerProvider newJMXConnectorServerProvider(JMXServiceURL url, Map env) throws IOException {
        String protocol = ProviderFactory.normalizeProtocol(url.getProtocol());
        String providerPackages = ProviderFactory.findProviderPackageList(env, "jmx.remote.protocol.provider.pkgs");
        ClassLoader classLoader = ProviderFactory.findProviderClassLoader(env, "jmx.remote.protocol.provider.class.loader");
        JMXConnectorServerProvider provider = (JMXConnectorServerProvider)ProviderFactory.loadProvider(providerPackages, protocol, "ServerProvider", classLoader);
        return provider;
    }

    private static String findEnvironmentProviderPackageList(Map environment, String key) throws JMXProviderException {
        String providerPackages = null;
        if (environment != null) {
            Logger logger = ProviderFactory.getLogger();
            Object pkgs = environment.get(key);
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider packages in the environment: " + pkgs);
            }
            if (pkgs != null && !(pkgs instanceof String)) {
                throw new JMXProviderException("Provider package list must be a string");
            }
            providerPackages = (String)pkgs;
        }
        return providerPackages;
    }

    private static String findProviderPackageList(Map environment, String providerPkgsKey) throws JMXProviderException {
        String providerPackages = ProviderFactory.findEnvironmentProviderPackageList(environment, providerPkgsKey);
        if (providerPackages == null) {
            providerPackages = ProviderFactory.findSystemPackageList(providerPkgsKey);
        }
        if (providerPackages != null && providerPackages.trim().length() == 0) {
            throw new JMXProviderException("Provider package list cannot be an empty string");
        }
        providerPackages = providerPackages == null ? "mx4j.remote.provider|mx4j.tools.remote.provider" : providerPackages + "|mx4j.remote.provider|mx4j.tools.remote.provider";
        Logger logger = ProviderFactory.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Provider packages list is: " + providerPackages);
        }
        return providerPackages;
    }

    private static ClassLoader findProviderClassLoader(Map environment, String providerLoaderKey) {
        Logger logger = ProviderFactory.getLogger();
        ClassLoader classLoader = null;
        if (environment != null) {
            Object loader = environment.get(providerLoaderKey);
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider classloader in the environment: " + loader);
            }
            if (loader != null && !(loader instanceof ClassLoader)) {
                throw new IllegalArgumentException("Provider classloader is not a ClassLoader");
            }
            classLoader = (ClassLoader)loader;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider classloader in the environment: " + classLoader);
            }
        }
        environment.put("jmx.remote.protocol.provider.class.loader", classLoader);
        if (logger.isEnabledFor(0)) {
            logger.trace("Provider classloader added to the environment");
        }
        return classLoader;
    }

    private static Object loadProvider(String packages, String protocol, String className, ClassLoader loader) throws JMXProviderException, MalformedURLException {
        Logger logger = ProviderFactory.getLogger();
        StringTokenizer tokenizer = new StringTokenizer(packages, "|");
        while (tokenizer.hasMoreTokens()) {
            String pkg = tokenizer.nextToken().trim();
            if (logger.isEnabledFor(10)) {
                logger.debug("Provider package: " + pkg);
            }
            if (pkg.length() == 0) {
                throw new JMXProviderException("Empty package list not allowed: " + packages);
            }
            String providerClassName = ProviderFactory.constructClassName(pkg, protocol, className);
            Class providerClass = null;
            try {
                providerClass = ProviderFactory.loadClass(providerClassName, loader);
            }
            catch (ClassNotFoundException x) {
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Provider class " + providerClassName + " not found, continuing with next package");
                continue;
            }
            catch (Exception x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Cannot load provider class " + providerClassName, x);
                }
                throw new JMXProviderException("Cannot load provider class " + providerClassName, x);
            }
            try {
                return providerClass.newInstance();
            }
            catch (Exception x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Cannot instantiate provider class " + providerClassName, x);
                }
                throw new JMXProviderException("Cannot instantiate provider class " + providerClassName, x);
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Could not find provider for protocol " + protocol + " in package list '" + packages + "'");
        }
        throw new MalformedURLException("Could not find provider for protocol " + protocol + " in package list '" + packages + "'");
    }
}

