/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.execution.FlowProcessingPhase;
import org.mule.execution.FlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.execution.ValidationPhase;
import org.mule.message.processing.PhaseSupportTestHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class FlowProcessingPhaseTestCase
extends AbstractMuleTestCase {
    private FlowProcessingPhase phase = new FlowProcessingPhase();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowProcessingPhaseTemplate mockTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private RequestResponseFlowProcessingPhaseTemplate mockRequestResponseTemplate;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessContext mockContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private PhaseResultNotifier mockNotifier;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessagingException mockMessagingException;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleException mockException;

    @Test
    public void supportedTemplates() {
        new PhaseSupportTestHelper<FlowProcessingPhaseTemplate>(FlowProcessingPhaseTemplate.class).testSupportTemplates((MessageProcessPhase)this.phase);
    }

    @Test
    public void order() {
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)new ValidationPhase()), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.phase.compareTo((MessageProcessPhase)Mockito.mock(MessageProcessPhase.class)), (Matcher)Is.is((Object)0));
    }

    @Test
    public void runPhaseWithExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        ((FlowProcessingPhaseTemplate)Mockito.doThrow((Throwable)this.mockException).when((Object)this.mockTemplate)).afterSuccessfulProcessingFlow((MuleEvent)Matchers.any(MuleEvent.class));
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((FlowConstruct)Mockito.verify((Object)this.mockContext.getFlowConstruct(), (VerificationMode)Mockito.times((int)1))).getExceptionListener();
        this.verifyOnlyFailureWasCalled((Exception)((Object)this.mockException));
    }

    @Test
    public void runPhaseWithMessagingExceptionThrown() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        Mockito.when((Object)this.mockTemplate.routeEvent((MuleEvent)Mockito.any(MuleEvent.class))).thenThrow(new Throwable[]{this.mockMessagingException});
        this.phase.runPhase(this.mockTemplate, this.mockContext, this.mockNotifier);
        ((FlowConstruct)Mockito.verify((Object)this.mockContext.getFlowConstruct(), (VerificationMode)Mockito.times((int)1))).getExceptionListener();
        this.verifyOnlySuccessfulWasCalled();
    }

    @Test
    public void callSendResponseForRequestResponseTemplate() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        this.verifyOnlySuccessfulWasCalled();
        ((RequestResponseFlowProcessingPhaseTemplate)Mockito.verify((Object)this.mockRequestResponseTemplate, (VerificationMode)Mockito.times((int)1))).sendResponseToClient((MuleEvent)Matchers.any(MuleEvent.class));
    }

    @Test
    public void successfulPhaseExecutionInOrder() throws Exception {
        Mockito.when((Object)this.mockContext.supportsAsynchronousProcessing()).thenReturn((Object)false);
        this.phase.runPhase((FlowProcessingPhaseTemplate)this.mockRequestResponseTemplate, this.mockContext, this.mockNotifier);
        InOrder inOrderVerify = Mockito.inOrder((Object[])new Object[]{this.mockContext, this.mockContext.getFlowConstruct(), this.mockRequestResponseTemplate, this.mockNotifier});
        ((MessageProcessContext)inOrderVerify.verify((Object)this.mockContext, Mockito.atLeastOnce())).getTransactionConfig();
        ((FlowConstruct)inOrderVerify.verify((Object)this.mockContext.getFlowConstruct(), Mockito.times((int)1))).getExceptionListener();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate, Mockito.times((int)1))).getMuleEvent();
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate, Mockito.times((int)1))).beforeRouteEvent((MuleEvent)Matchers.any(MuleEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate, Mockito.times((int)1))).routeEvent((MuleEvent)Matchers.any(MuleEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate, Mockito.times((int)1))).afterRouteEvent((MuleEvent)Matchers.any(MuleEvent.class));
        ((RequestResponseFlowProcessingPhaseTemplate)inOrderVerify.verify((Object)this.mockRequestResponseTemplate, Mockito.times((int)1))).afterSuccessfulProcessingFlow((MuleEvent)Matchers.any(MuleEvent.class));
        ((PhaseResultNotifier)inOrderVerify.verify((Object)this.mockNotifier, Mockito.times((int)1))).phaseSuccessfully();
        this.verifyOnlySuccessfulWasCalled();
    }

    private void verifyOnlySuccessfulWasCalled() {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)0))).phaseFailure((Exception)Matchers.any(Exception.class));
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)0))).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)1))).phaseSuccessfully();
    }

    private void verifyOnlyFailureWasCalled(Exception e) {
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)1))).phaseFailure(e);
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)0))).phaseConsumedMessage();
        ((PhaseResultNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.times((int)0))).phaseSuccessfully();
    }
}

