/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.CollectionUtils;

public class CatchAllStrategiesTestCase
extends AbstractMuleContextTestCase {
    public CatchAllStrategiesTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testLoggingOnlyStrategy() throws Exception {
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        LoggingCatchAllStrategy strategy = new LoggingCatchAllStrategy();
        strategy.process(event);
    }

    @Test
    public void testForwardingStrategy() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        OutboundEndpoint endpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.setEndpoint(endpoint);
        strategy.process(event);
        ((OutboundEndpoint)Mockito.verify((Object)endpoint)).process((MuleEvent)Matchers.any(DefaultMuleEvent.class));
        Assert.assertNotNull((Object)strategy.getEndpoint());
    }

    @Test
    public void testForwardingStrategyNullEndpoint() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setEndpoint(null);
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        try {
            strategy.process(event);
            Assert.fail();
        }
        catch (RoutingException routingException) {
            // empty catch block
        }
    }

    @Test
    public void testForwardingStrategyWithTransform() throws Exception {
        OutboundEndpoint endpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        Mockito.when((Object)endpoint.getTransformers()).thenReturn((Object)CollectionUtils.singletonList((Object)((Object)new TestEventTransformer())));
        Mockito.when((Object)endpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                Assert.assertEquals((long)1L, (long)invocation.getArguments().length);
                Assert.assertTrue((boolean)(invocation.getArguments()[0] instanceof MuleEvent));
                MuleEvent event = (MuleEvent)invocation.getArguments()[0];
                Assert.assertEquals((Object)"Transformed Test Data", (Object)event.getMessage().getPayload());
                return null;
            }
        });
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setSendTransformed(true);
        strategy.setEndpoint(endpoint);
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.process(event);
        Assert.assertNotNull((Object)strategy.getEndpoint());
    }

    @Test
    public void testFullRouter() throws Exception {
        final int[] count1 = new int[]{0};
        final int[] count2 = new int[]{0};
        final int[] catchAllCount = new int[]{0};
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        FilteringOutboundRouter filterRouter1 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) {
                count1[0] = count1[0] + 1;
                return event;
            }
        };
        FilteringOutboundRouter filterRouter2 = new FilteringOutboundRouter(){

            public MuleEvent route(MuleEvent event) {
                count2[0] = count2[0] + 1;
                return event;
            }
        };
        filterRouter1.setFilter((Filter)new PayloadTypeFilter(Exception.class));
        filterRouter2.setFilter((Filter)new PayloadTypeFilter(StringBuffer.class));
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter1);
        messageRouter.addRoute((MatchableMessageProcessor)filterRouter2);
        AbstractCatchAllStrategy strategy = new AbstractCatchAllStrategy(){

            public MuleEvent doCatchMessage(MuleEvent event) {
                catchAllCount[0] = catchAllCount[0] + 1;
                return null;
            }
        };
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)strategy);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent("hello"));
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)0L, (long)count1[0]);
        Assert.assertEquals((long)0L, (long)count2[0]);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent(new StringBuffer()));
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)0L, (long)count1[0]);
        Assert.assertEquals((long)1L, (long)count2[0]);
        messageRouter.process(CatchAllStrategiesTestCase.getTestEvent(new Exception()));
        Assert.assertEquals((long)1L, (long)catchAllCount[0]);
        Assert.assertEquals((long)1L, (long)count1[0]);
        Assert.assertEquals((long)1L, (long)count2[0]);
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        public Object doTransform(Object src, String outputEncoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

