/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.compression.GZipCompressTransformer;
import org.mule.transformer.compression.GZipTransformerTestCase;
import org.mule.transformer.compression.GZipUncompressTransformer;
import org.mule.util.IOUtils;
import org.mule.util.SerializationUtils;

public class GZipTransformerStreamTestCase
extends GZipTransformerTestCase {
    @Test
    public void testStreamingCompression() throws TransformerException {
        GZipCompressTransformer transformer = (GZipCompressTransformer)super.getTransformer();
        ByteArrayInputStream uncompressedInputStream = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)((Object)"the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog")));
        InputStream compressedInputStream = (InputStream)transformer.transform((Object)uncompressedInputStream);
        byte[] compressedBytes = (byte[])this.getResultData();
        Assert.assertTrue((boolean)Arrays.equals(compressedBytes, IOUtils.toByteArray((InputStream)compressedInputStream)));
        IOUtils.closeQuietly((InputStream)uncompressedInputStream);
        IOUtils.closeQuietly((InputStream)compressedInputStream);
    }

    @Test
    public void testStreamingDecompression() throws TransformerException {
        GZipUncompressTransformer transformer = new GZipUncompressTransformer();
        transformer.setMuleContext(muleContext);
        ByteArrayInputStream compressedInputStream = new ByteArrayInputStream((byte[])this.getResultData());
        InputStream decompressedInputStream = (InputStream)transformer.transform((Object)compressedInputStream);
        Assert.assertEquals((Object)"the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog", (Object)SerializationUtils.deserialize((byte[])IOUtils.toByteArray((InputStream)decompressedInputStream)));
        IOUtils.closeQuietly((InputStream)compressedInputStream);
        IOUtils.closeQuietly((InputStream)decompressedInputStream);
    }

    @Test
    public void testStreamingCompressionDecompression() throws TransformerException {
        GZipCompressTransformer compressTransformer = (GZipCompressTransformer)super.getTransformer();
        GZipUncompressTransformer decompressTransformer = new GZipUncompressTransformer();
        decompressTransformer.setMuleContext(muleContext);
        ByteArrayInputStream input = new ByteArrayInputStream(SerializationUtils.serialize((Serializable)((Object)"the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog")));
        InputStream compressedInputStream = (InputStream)compressTransformer.transform((Object)input);
        InputStream decompressedInputStream = (InputStream)decompressTransformer.transform((Object)compressedInputStream);
        Assert.assertEquals((Object)SerializationUtils.deserialize((byte[])IOUtils.toByteArray((InputStream)decompressedInputStream)), (Object)"the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog");
        IOUtils.closeQuietly((InputStream)compressedInputStream);
        IOUtils.closeQuietly((InputStream)decompressedInputStream);
    }
}

