/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.builder.MockTransformerBuilder;
import org.mule.transformer.graph.GraphTransformerResolver;

@SmallTest
public class GraphTransformerResolverTestCase
extends AbstractMuleTestCase {
    private static final DataType XML_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"XML_DATA_TYPE");
    private static final DataType JSON_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"JSON_DATA_TYPE");
    private static final DataType INPUT_STREAM_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"INPUT_STREAM_DATA_TYPE");
    private static final DataType STRING_DATA_TYPE = (DataType)Mockito.mock(DataType.class, (String)"STRING_DATA_TYPE");
    private GraphTransformerResolver graphResolver = new GraphTransformerResolver();

    @BeforeClass
    public static void setupDataTypes() {
        ((DataType)Mockito.doReturn((Object)true).when((Object)XML_DATA_TYPE)).isCompatibleWith(XML_DATA_TYPE);
        ((DataType)Mockito.doReturn(XML_CLASS.class).when((Object)XML_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)JSON_DATA_TYPE)).isCompatibleWith(JSON_DATA_TYPE);
        ((DataType)Mockito.doReturn(JSON_CLASS.class).when((Object)JSON_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)INPUT_STREAM_DATA_TYPE)).isCompatibleWith(INPUT_STREAM_DATA_TYPE);
        ((DataType)Mockito.doReturn(INPUT_STREAM_CLASS.class).when((Object)INPUT_STREAM_DATA_TYPE)).getType();
        ((DataType)Mockito.doReturn((Object)true).when((Object)STRING_DATA_TYPE)).isCompatibleWith(STRING_DATA_TYPE);
        ((DataType)Mockito.doReturn(STRING_CLASS.class).when((Object)STRING_DATA_TYPE)).getType();
    }

    @Test
    public void cachesResolvedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void clearsCacheWhenAddsConverter() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer1);
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void ignoresAddedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer1);
        Transformer xmlToString = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange(xmlToString, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void ignoresRemovedTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToXml")).from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer1 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer1);
        Transformer xmlToString = ((MockTransformerBuilder)((MockTransformerBuilder)((MockTransformerBuilder)new MockTransformerBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).build();
        this.graphResolver.transformerChange(xmlToString, TransformerResolver.RegistryAction.REMOVED);
        Transformer transformer2 = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertSame((Object)transformer1, (Object)transformer2);
    }

    @Test
    public void clearsCacheWhenRemovesTransformer() throws ResolverException {
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).build();
        Converter inputStreamToXml = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(INPUT_STREAM_DATA_TYPE)).to(XML_DATA_TYPE)).build();
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNotNull((Object)transformer);
        this.graphResolver.transformerChange((Transformer)inputStreamToXml, TransformerResolver.RegistryAction.REMOVED);
        transformer = this.graphResolver.resolve(INPUT_STREAM_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertNull((Object)transformer);
    }

    @Test
    public void resolvesTransformersWithDifferentLength() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToJson")).from(XML_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertEquals((Object)xmlToJson, (Object)transformer);
    }

    @Test
    public void resolvesTransformersWithSameLengthAndDifferentWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(2)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)stringToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter compositeConverter = (CompositeConverter)transformer;
        Assert.assertEquals((long)2L, (long)compositeConverter.getConverters().size());
        Assert.assertEquals((Object)xmlToInputStream, compositeConverter.getConverters().get(0));
        Assert.assertEquals((Object)inputStreamToJson, compositeConverter.getConverters().get(1));
    }

    @Test
    public void resolvesTransformerWithSameLengthAndSameWeight() throws ResolverException {
        Converter xmlToInputStream = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToString = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).from(XML_DATA_TYPE)).to(STRING_DATA_TYPE)).weighting(1)).build();
        Converter inputStreamToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("inputStreamToJson")).from(INPUT_STREAM_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        Converter stringToJson = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).from(STRING_DATA_TYPE)).to(JSON_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToString, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)inputStreamToJson, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)stringToJson, TransformerResolver.RegistryAction.ADDED);
        Transformer transformer = this.graphResolver.resolve(XML_DATA_TYPE, JSON_DATA_TYPE);
        Assert.assertTrue((boolean)(transformer instanceof CompositeConverter));
        CompositeConverter compositeConverter = (CompositeConverter)transformer;
        Assert.assertEquals((long)2L, (long)compositeConverter.getConverters().size());
        Assert.assertEquals((Object)xmlToInputStream, compositeConverter.getConverters().get(0));
        Assert.assertEquals((Object)inputStreamToJson, compositeConverter.getConverters().get(1));
    }

    @Test(expected=ResolverException.class)
    public void cannotResolveTransformerWithSameLengthAndSameWeightAndSameName() throws ResolverException {
        Converter xmlToInputStream1 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        Converter xmlToInputStream2 = ((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().named("xmlToInputStream")).from(XML_DATA_TYPE)).to(INPUT_STREAM_DATA_TYPE)).weighting(1)).build();
        this.graphResolver.transformerChange((Transformer)xmlToInputStream1, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.transformerChange((Transformer)xmlToInputStream2, TransformerResolver.RegistryAction.ADDED);
        this.graphResolver.resolve(XML_DATA_TYPE, INPUT_STREAM_DATA_TYPE);
    }

    private static class STRING_CLASS {
        private STRING_CLASS() {
        }
    }

    private static class INPUT_STREAM_CLASS {
        private INPUT_STREAM_CLASS() {
        }
    }

    private static class JSON_CLASS {
        private JSON_CLASS() {
        }
    }

    private static class XML_CLASS {
        private XML_CLASS() {
        }
    }
}

