/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.MuleObjectStoreManager;

@RunWith(value=Parameterized.class)
public class MuleObjectStoreManagerTestCase
extends AbstractMuleContextTestCase {
    public static final String OBJECT_KEY = "key";
    public static final String OBJECT_KEY_VALUE_1 = "value";
    public static final String OBJECT_KEY_VALUE_2 = "anotherValue";
    private final ObjectStoreFactory objectStoreFactory;

    public MuleObjectStoreManagerTestCase(ObjectStoreFactory objectStoreFactory) {
        this.objectStoreFactory = objectStoreFactory;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new ObjectStoreFactory(false, ObjectStoreType.DEFAULT)}, {new ObjectStoreFactory(true, ObjectStoreType.DEFAULT)}, {new ObjectStoreFactory(false, ObjectStoreType.USER)}, {new ObjectStoreFactory(true, ObjectStoreType.USER)});
    }

    @Before
    public void injectMuleContext() {
        this.objectStoreFactory.setMuleObjectStoreManager((MuleObjectStoreManager)muleContext.getRegistry().get("_muleObjectStoreManager"));
    }

    @Test
    public void partitionObjectStoreDoesNotCollide() throws Exception {
        Object os = this.objectStoreFactory.createObjectStore("myOs");
        Object os2 = this.objectStoreFactory.createObjectStore("myOs2");
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
        os2.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)os.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((String)((Object)os.retrieve((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)os2.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((String)((Object)os2.retrieve((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)((String)((Object)os.remove((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)((String)((Object)os2.remove((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
    }

    @Ignore
    @Test(expected=ObjectStoreException.class)
    public void maxEntriesIshonored() throws Exception {
        Object os = this.objectStoreFactory.createObjectStore("myOs", 5, 0, 60000);
        int maxEntries = 5;
        for (int i = 0; i < maxEntries; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
    }

    @Test
    public void expirationIntervalWithLowTTL() throws Exception {
        int maxEntries = 5;
        int entryTTL = 10;
        ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, 100);
        for (int i = 0; i < maxEntries; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
        Thread.sleep(entryTTL * 30);
        Assert.assertThat((Object)os.allKeys().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void expirationIntervalWithHighTTLPersistentObjectStore() throws Exception {
        int i;
        int maxEntries = 5;
        int entryTTL = 10000;
        ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, 100);
        for (i = 0; i < maxEntries; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
        Thread.sleep(entryTTL / 5);
        Assert.assertThat((Object)os.allKeys().size(), (Matcher)Is.is((Object)maxEntries));
        for (i = 1; i < maxEntries; ++i) {
            Assert.assertThat((Object)os.contains((Serializable)Integer.valueOf(i)), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)os.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
    }

    private static class ObjectStoreFactory {
        private final boolean isPersistent;
        private final ObjectStoreType objectStoreType;
        private MuleObjectStoreManager muleObjectStoreManager;

        public ObjectStoreFactory(boolean isPersistent, ObjectStoreType objectStoreType) {
            this.isPersistent = isPersistent;
            this.objectStoreType = objectStoreType;
        }

        public void setMuleObjectStoreManager(MuleObjectStoreManager muleObjectStoreManager) {
            this.muleObjectStoreManager = muleObjectStoreManager;
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name) {
            if (this.objectStoreType.equals((Object)ObjectStoreType.USER)) {
                return (T)this.muleObjectStoreManager.getUserObjectStore(name, this.isPersistent);
            }
            return (T)this.muleObjectStoreManager.getObjectStore(name, this.isPersistent);
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, int maxEntries, int entryTTL, int expirationInterval) {
            if (this.objectStoreType.equals((Object)ObjectStoreType.USER)) {
                return (T)this.muleObjectStoreManager.getUserObjectStore(name, this.isPersistent, maxEntries, entryTTL, expirationInterval);
            }
            return (T)this.muleObjectStoreManager.getObjectStore(name, this.isPersistent, maxEntries, entryTTL, expirationInterval);
        }
    }

    private static enum ObjectStoreType {
        DEFAULT,
        USER;

    }
}

