/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.job.Timer;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.jobexecutor.JobAdditionNotifier;
import org.jbpm.pvm.internal.session.TimerSession;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorTimerSession
implements TimerSession {
    private static final Log log = Log.getLog((String)TimerSession.class.getName());
    Session session;
    JobAdditionNotifier jobAdditionNotifier;

    @Override
    public void schedule(Timer timer) {
        if (timer == null) {
            throw new JbpmException("null timer scheduled");
        }
        TimerImpl timerImpl = (TimerImpl)timer;
        timerImpl.validate();
        log.debug("scheduling " + timer);
        this.session.save((Object)timer);
        if (this.jobAdditionNotifier != null) {
            this.jobAdditionNotifier.registerNotification();
        }
    }

    @Override
    public void cancel(Timer timer) {
        log.debug("canceling " + timer);
        if (timer == null) {
            throw new JbpmException("timer is null");
        }
        this.session.delete((Object)timer);
    }

    @Override
    public List<Timer> findTimersByExecution(Execution execution) {
        List timers = this.session.createCriteria(TimerImpl.class).add((Criterion)Restrictions.eq((String)"execution", (Object)execution)).list();
        return CollectionUtil.checkList(timers, Timer.class);
    }
}

