/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mule.api.el.datetime.Time;
import org.mule.el.context.ServerContext;
import org.mule.el.datetime.AbstractInstant;

public class DateTime
extends AbstractInstant
implements org.mule.api.el.datetime.Date,
Time {
    public DateTime(Calendar calendar, Locale locale) {
        super(calendar, locale);
    }

    public DateTime() {
        this(Calendar.getInstance(ServerContext.getLocale()), ServerContext.getLocale());
    }

    public DateTime(Calendar calendar) {
        this(calendar, ServerContext.getLocale());
    }

    public DateTime(Date date) {
        this(Calendar.getInstance(ServerContext.getTimeZone(), ServerContext.getLocale()), ServerContext.getLocale());
        this.calendar.setTime(date);
    }

    public DateTime(XMLGregorianCalendar xmlCalendar) {
        this(xmlCalendar.toGregorianCalendar(), ServerContext.getLocale());
    }

    public DateTime(String iso8601String) {
        this(datatypeFactory.newXMLGregorianCalendar(iso8601String).toGregorianCalendar());
    }

    public DateTime(String dateString, String format) throws ParseException {
        this(Calendar.getInstance(TimeZone.getTimeZone("UTC"), ServerContext.getLocale()), ServerContext.getLocale());
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setCalendar(this.calendar);
        dateFormat.parse(dateString);
    }

    public String toString() {
        return DatatypeConverter.printDateTime((Calendar)this.calendar);
    }

    @Override
    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    @Override
    public int getDayOfMonth() {
        return this.calendar.get(5);
    }

    @Override
    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    @Override
    public int getWeekOfMonth() {
        return this.calendar.get(4);
    }

    @Override
    public int getWeekOfYear() {
        return this.calendar.get(3);
    }

    @Override
    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    @Override
    public int getYear() {
        return this.calendar.get(1);
    }

    @Override
    public DateTime plusDays(int add) {
        this.calendar.add(6, add);
        return this;
    }

    @Override
    public DateTime plusWeeks(int add) {
        this.calendar.add(3, add);
        return this;
    }

    @Override
    public DateTime plusMonths(int add) {
        this.calendar.add(2, add);
        return this;
    }

    @Override
    public DateTime plusYears(int add) {
        this.calendar.add(1, add);
        return this;
    }

    @Override
    public DateTime plusMilliSeconds(int add) {
        this.calendar.add(14, add);
        return this;
    }

    @Override
    public DateTime plusSeconds(int add) {
        this.calendar.add(13, add);
        return this;
    }

    @Override
    public DateTime plusMinutes(int add) {
        this.calendar.add(12, add);
        return this;
    }

    @Override
    public DateTime plusHours(int add) {
        this.calendar.add(11, add);
        return this;
    }

    @Override
    public long getMilliSeconds() {
        return this.calendar.get(14);
    }

    @Override
    public int getSeconds() {
        return this.calendar.get(13);
    }

    @Override
    public int getMinutes() {
        return this.calendar.get(12);
    }

    @Override
    public int getHours() {
        return this.calendar.get(11);
    }

    @Override
    public DateTime withLocale(String locale) {
        super.withLocale(locale);
        return this;
    }

    @Override
    public DateTime withTimeZone(String newTimezone) {
        super.withTimeZone(newTimezone);
        return this;
    }

    @Override
    public DateTime changeTimeZone(String newTimezone) {
        super.changeTimeZone(newTimezone);
        return this;
    }

    public org.mule.api.el.datetime.Date getDate() {
        return new InternalDate((Calendar)this.calendar.clone(), this.locale);
    }

    public Time getTime() {
        return new InternalTime((Calendar)this.calendar.clone(), this.locale);
    }

    class InternalTime
    extends AbstractInstant
    implements Time {
        public InternalTime(Calendar calendar, Locale locale) {
            super(calendar, locale);
            this.resetDate();
        }

        @Override
        public Time plusMilliSeconds(int add) {
            this.calendar.add(14, add);
            this.resetDate();
            return this;
        }

        @Override
        public Time plusSeconds(int add) {
            this.calendar.add(13, add);
            this.resetDate();
            return this;
        }

        @Override
        public Time plusMinutes(int add) {
            this.calendar.add(12, add);
            this.resetDate();
            return this;
        }

        @Override
        public Time plusHours(int add) {
            this.calendar.add(11, add);
            this.resetDate();
            return this;
        }

        @Override
        public long getMilliSeconds() {
            return this.calendar.get(14);
        }

        @Override
        public int getSeconds() {
            return this.calendar.get(13);
        }

        @Override
        public int getMinutes() {
            return this.calendar.get(12);
        }

        @Override
        public int getHours() {
            return this.calendar.get(11);
        }

        @Override
        public Time changeTimeZone(String newTimezone) {
            super.changeTimeZone(newTimezone);
            this.resetDate();
            return this;
        }

        @Override
        public Time withLocale(String locale) {
            super.withLocale(locale);
            return this;
        }

        @Override
        public Time withTimeZone(String newTimezone) {
            super.withTimeZone(newTimezone);
            return this;
        }

        public String toString() {
            return DatatypeConverter.printTime((Calendar)this.calendar);
        }

        private void resetDate() {
            this.calendar.get(0);
            this.calendar.set(1, 1970);
            this.calendar.set(6, 1);
        }
    }

    class InternalDate
    extends AbstractInstant
    implements org.mule.api.el.datetime.Date {
        public InternalDate(Calendar calendar, Locale locale) {
            super(calendar, locale);
            this.resetTime();
        }

        protected void resetTime() {
            this.calendar.get(0);
            this.calendar.set(11, 0);
            this.calendar.set(12, 0);
            this.calendar.set(13, 0);
            this.calendar.set(14, 0);
        }

        @Override
        public int getDayOfWeek() {
            return this.calendar.get(7);
        }

        @Override
        public int getDayOfMonth() {
            return this.calendar.get(5);
        }

        @Override
        public int getDayOfYear() {
            return this.calendar.get(6);
        }

        @Override
        public int getWeekOfMonth() {
            return this.calendar.get(4);
        }

        @Override
        public int getWeekOfYear() {
            return this.calendar.get(3);
        }

        @Override
        public int getMonth() {
            return this.calendar.get(2) + 1;
        }

        @Override
        public int getYear() {
            return this.calendar.get(1);
        }

        @Override
        public org.mule.api.el.datetime.Date plusDays(int add) {
            this.calendar.add(6, add);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date plusWeeks(int add) {
            this.calendar.add(3, add);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date plusMonths(int add) {
            this.calendar.add(2, add);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date plusYears(int add) {
            this.calendar.add(1, add);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date withLocale(String locale) {
            super.withLocale(locale);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date withTimeZone(String newTimezone) {
            super.withTimeZone(newTimezone);
            return this;
        }

        @Override
        public org.mule.api.el.datetime.Date changeTimeZone(String newTimezone) {
            super.changeTimeZone(newTimezone);
            this.resetTime();
            return this;
        }

        public String toString() {
            return DatatypeConverter.printDate((Calendar)this.calendar);
        }
    }
}

