/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessageRedeliveredException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transformer.simple.ByteArrayToHexString;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.util.lock.LockFactory;
import org.mule.util.store.ObjectStorePartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private ObjectStore<AtomicInteger> store;
    private LockFactory lockFactory;
    private String idrId;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            try {
                MessageDigest.getInstance(this.messageDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Exception '%s' initializing message digest algorithm %s", e.getMessage(), this.messageDigestAlgorithm)), (Initialisable)this);
            }
        }
        String appName = this.muleContext.getConfiguration().getId();
        String flowName = this.flowConstruct.getName();
        this.idrId = String.format("%s-%s-%s", appName, flowName, "idr");
        this.lockFactory = this.muleContext.getLockFactory();
        this.store = this.createStore();
    }

    private ObjectStore<AtomicInteger> createStore() throws InitialisationException {
        ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        return objectStoreManager.getObjectStore(this.flowConstruct.getName() + "." + this.getClass().getName(), false, -1, 300000, 6000);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.store != null) {
            if (this.store instanceof ObjectStorePartition) {
                try {
                    ((ObjectStorePartition)this.store).close();
                }
                catch (ObjectStoreException e) {
                    this.logger.warn("error closing object store: " + e.getMessage(), (Throwable)e);
                }
            }
            this.store = null;
        }
        if (this.deadLetterQueue instanceof Disposable) {
            ((Disposable)((Object)this.deadLetterQueue)).dispose();
        }
    }

    @Override
    public void start() throws MuleException {
        if (this.deadLetterQueue instanceof Startable) {
            ((Startable)((Object)this.deadLetterQueue)).start();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        boolean exceptionSeen = false;
        boolean tooMany = false;
        AtomicInteger counter = null;
        String messageId = null;
        try {
            messageId = this.getIdForEvent(event);
        }
        catch (TransformerException e) {
            this.logger.warn("The message cannot be processed because the digest could not be generated. Either make the payload serializable or use an expression.");
            return null;
        }
        catch (Exception ex) {
            exceptionSeen = true;
        }
        Lock lock = this.lockFactory.createLock(this.idrId + "-" + messageId);
        lock.lock();
        try {
            if (!exceptionSeen) {
                counter = this.findCounter(messageId);
                boolean bl = tooMany = counter != null && counter.get() > this.maxRedeliveryCount;
            }
            if (tooMany || exceptionSeen) {
                block18: {
                    if (this.deadLetterQueue == null) break block18;
                    MuleEvent muleEvent = this.deadLetterQueue.process(event);
                    return muleEvent;
                }
                try {
                    throw new MessageRedeliveredException(messageId, counter.get(), this.maxRedeliveryCount, null, event);
                }
                catch (MessageRedeliveredException ex) {
                    throw ex;
                }
                catch (Exception ex2) {
                    this.logger.info("Exception thrown from failed message processing for message " + messageId, (Throwable)ex2);
                    MuleEvent ex2 = null;
                    return ex2;
                }
            }
            MuleEvent returnEvent = this.processNext(event);
            counter = this.findCounter(messageId);
            if (counter != null) {
                this.resetCounter(messageId);
            }
            MuleEvent muleEvent = returnEvent;
            return muleEvent;
        }
        finally {
            lock.unlock();
        }
    }

    private void resetCounter(String messageId) throws ObjectStoreException {
        this.store.remove((Serializable)((Object)messageId));
        this.store.store((Serializable)((Object)messageId), new AtomicInteger());
    }

    public AtomicInteger findCounter(String messageId) throws ObjectStoreException {
        boolean counterExists = this.store.contains((Serializable)((Object)messageId));
        if (counterExists) {
            return this.store.retrieve((Serializable)((Object)messageId));
        }
        return null;
    }

    private AtomicInteger incrementCounter(String messageId) throws ObjectStoreException {
        AtomicInteger counter = this.findCounter(messageId);
        if (counter == null) {
            counter = new AtomicInteger();
        } else {
            this.store.remove((Serializable)((Object)messageId));
        }
        counter.incrementAndGet();
        this.store.store((Serializable)((Object)messageId), counter);
        return counter;
    }

    private String getIdForEvent(MuleEvent event) throws Exception {
        if (this.useSecureHash) {
            Object payload = event.getMessage().getPayload();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            if (payload instanceof InputStream) {
                event.getMessage().setPayload(bytes);
            }
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        return event.getMuleContext().getExpressionManager().parse(this.idExpression, event, true);
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public void setMessageProcessor(MessageProcessor processor) {
        this.deadLetterQueue = processor;
    }
}

