/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;

public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder {
    public DefaultMessageProcessorChainBuilder() {
    }

    public DefaultMessageProcessorChainBuilder(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public MessageProcessorChain build() throws MuleException {
        LinkedList<MessageProcessor> tempList = new LinkedList<MessageProcessor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            MessageProcessor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (processor instanceof InterceptingMessageProcessor) {
                InterceptingMessageProcessor interceptingProcessor = (InterceptingMessageProcessor)processor;
                if (i + 1 < this.processors.size()) {
                    if (tempList.isEmpty()) {
                        interceptingProcessor.setListener(this.initializeMessageProcessor(this.processors.get(i + 1)));
                    } else if (tempList.size() == 1) {
                        interceptingProcessor.setListener(tempList.get(0));
                    } else {
                        interceptingProcessor.setListener(this.createInnerChain(tempList));
                    }
                }
                tempList = new LinkedList<MessageProcessor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(this.initializeMessageProcessor(processor));
        }
        DefaultMessageProcessorChain chain = this.createOuterChain(tempList);
        return this.buildMessageProcessorChain(chain);
    }

    protected MessageProcessorChain buildMessageProcessorChain(DefaultMessageProcessorChain chain) {
        return new InterceptingChainLifecycleWrapper(chain, this.processors, "wrapper for " + this.name);
    }

    protected DefaultMessageProcessorChain createInnerChain(LinkedList<MessageProcessor> tempList) {
        return new DefaultMessageProcessorChain("(inner iterating chain) of " + this.name, new ArrayList<MessageProcessor>(tempList));
    }

    protected DefaultMessageProcessorChain createOuterChain(LinkedList<MessageProcessor> tempList) {
        return new DefaultMessageProcessorChain("(inner iterating chain) of " + this.name, new ArrayList<MessageProcessor>(tempList));
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<MessageProcessor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }
}

