/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.WildcardAttributeEvaluator;

public abstract class AbstractRemoveVariablePropertyTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator identifierEvaluator;
    private WildcardAttributeEvaluator wildcardAttributeEvaluator;

    public AbstractRemoveVariablePropertyTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.identifierEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(final MuleMessage message, String outputEncoding) throws TransformerException {
        if (this.wildcardAttributeEvaluator.hasWildcards()) {
            this.wildcardAttributeEvaluator.processValues(message.getPropertyNames(this.getScope()), new WildcardAttributeEvaluator.MatchCallback(){

                @Override
                public void processMatch(String matchedValue) {
                    message.removeProperty(matchedValue, AbstractRemoveVariablePropertyTransformer.this.getScope());
                    if (AbstractRemoveVariablePropertyTransformer.this.logger.isDebugEnabled()) {
                        AbstractRemoveVariablePropertyTransformer.this.logger.debug((Object)String.format("Removing property: '%s' from scope: '%s'", matchedValue, AbstractRemoveVariablePropertyTransformer.this.getScope().getScopeName()));
                    }
                }
            });
        } else {
            Object keyValue = this.identifierEvaluator.resolveValue(message);
            if (keyValue != null) {
                message.removeProperty(keyValue.toString(), this.getScope());
            } else {
                this.logger.info((Object)"Key expression return null, no property will be removed");
            }
        }
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractRemoveVariablePropertyTransformer clone = (AbstractRemoveVariablePropertyTransformer)super.clone();
        clone.setIdentifier(this.identifierEvaluator.getRawValue());
        return clone;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Remove with null identifier is not supported");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier);
        this.wildcardAttributeEvaluator = new WildcardAttributeEvaluator(identifier);
    }

    public abstract PropertyScope getScope();
}

