/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.source.MessageSource;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.PropertyScope;
import org.mule.execution.FlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.ValidationPhaseTemplate;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.AbstractTransportMessageHandler;
import org.mule.transport.ResponseDispatchMessagingException;
import org.mule.util.ObjectUtils;

public abstract class AbstractTransportMessageProcessTemplate<MessageReceiverType extends AbstractMessageReceiver, ConnectorType extends AbstractConnector>
implements FlowProcessingPhaseTemplate,
ValidationPhaseTemplate,
MessageProcessContext {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final MessageReceiverType messageReceiver;
    private Object rawMessage;
    private WorkManager flowExecutionWorkManager;

    public AbstractTransportMessageProcessTemplate(MessageReceiverType messageReceiver, WorkManager flowExecutionWorkManager) {
        this.messageReceiver = messageReceiver;
        this.flowExecutionWorkManager = flowExecutionWorkManager;
    }

    @Override
    public MuleEvent getMuleEvent() throws MuleException {
        MuleMessage messageFromSource = this.createMessageFromSource(this.getOriginalMessage());
        return this.createEventFromMuleMessage(messageFromSource);
    }

    @Override
    public MessageSource getMessageSource() {
        return ((AbstractMessageReceiver)this.messageReceiver).getEndpoint();
    }

    @Override
    public Object getOriginalMessage() throws MuleException {
        if (this.rawMessage == null) {
            this.rawMessage = this.acquireMessage();
        }
        return this.rawMessage;
    }

    @Override
    public void afterFailureProcessingFlow(MessagingException messagingException) throws MuleException {
    }

    @Override
    public void afterFailureProcessingFlow(MuleException exception) throws MuleException {
    }

    @Override
    public MuleEvent routeEvent(MuleEvent muleEvent) throws MuleException {
        return ((AbstractMessageReceiver)this.messageReceiver).routeEvent(muleEvent);
    }

    protected void sendResponseMessage(MuleEvent responseMuleEvent) throws MessagingException {
    }

    @Override
    public void afterSuccessfulProcessingFlow(MuleEvent response) throws MuleException {
        if (((AbstractMessageReceiver)this.messageReceiver).getEndpoint().getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            try {
                this.sendResponseMessage(response);
            }
            catch (MessagingException e) {
                throw new ResponseDispatchMessagingException(response, (Throwable)e);
            }
        }
    }

    public abstract Object acquireMessage() throws MuleException;

    protected void propagateRootMessageIdProperty(MuleMessage message) {
        String rootId = (String)message.getInboundProperty("MULE_ROOT_MESSAGE_ID");
        if (rootId != null) {
            message.setMessageRootId(rootId);
            message.removeProperty("MULE_ROOT_MESSAGE_ID", PropertyScope.INBOUND);
        }
    }

    @Override
    public boolean validateMessage() {
        return true;
    }

    @Override
    public void discardInvalidMessage() throws MuleException {
    }

    protected void warnIfMuleClientSendUsed(MuleMessage message) {
        Object remoteSyncProperty = message.removeProperty("MULE_REMOTE_SYNC", PropertyScope.INBOUND);
        if (ObjectUtils.getBoolean(remoteSyncProperty, false) && !((AbstractMessageReceiver)this.messageReceiver).getEndpoint().getExchangePattern().hasResponse()) {
            this.logger.warn((Object)("MuleClient.send() was used but inbound endpoint " + ((AbstractMessageReceiver)this.messageReceiver).getEndpoint().getEndpointURI().getUri().toString() + " is not 'request-response'.  No response will be returned."));
        }
        message.removeProperty("MULE_REMOTE_SYNC", PropertyScope.INBOUND);
    }

    protected MuleEvent createEventFromMuleMessage(MuleMessage muleMessage) throws MuleException {
        MuleEvent muleEvent = ((AbstractMessageReceiver)this.messageReceiver).createMuleEvent(muleMessage, this.getOutputStream());
        if (!((AbstractMessageReceiver)this.messageReceiver).getEndpoint().isDisableTransportTransformer()) {
            ((AbstractMessageReceiver)this.messageReceiver).applyInboundTransformers(muleEvent);
        }
        return muleEvent;
    }

    protected OutputStream getOutputStream() {
        return null;
    }

    protected MuleMessage createMessageFromSource(Object message) throws MuleException {
        MuleMessage muleMessage = ((AbstractTransportMessageHandler)this.messageReceiver).createMuleMessage(message, ((AbstractMessageReceiver)this.messageReceiver).getEndpoint().getEncoding());
        this.warnIfMuleClientSendUsed(muleMessage);
        this.propagateRootMessageIdProperty(muleMessage);
        return muleMessage;
    }

    protected MessageReceiverType getMessageReceiver() {
        return this.messageReceiver;
    }

    protected InboundEndpoint getInboundEndpoint() {
        return ((AbstractMessageReceiver)this.messageReceiver).getEndpoint();
    }

    protected ConnectorType getConnector() {
        return (ConnectorType)((AbstractConnector)((AbstractTransportMessageHandler)this.messageReceiver).getConnector());
    }

    protected MuleContext getMuleContext() {
        return ((AbstractMessageReceiver)this.messageReceiver).getEndpoint().getMuleContext();
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return ((AbstractMessageReceiver)this.messageReceiver).getFlowConstruct();
    }

    @Override
    public boolean supportsAsynchronousProcessing() {
        return true;
    }

    @Override
    public MuleEvent beforeRouteEvent(MuleEvent muleEvent) throws MuleException {
        return muleEvent;
    }

    @Override
    public MuleEvent afterRouteEvent(MuleEvent muleEvent) throws MuleException {
        return muleEvent;
    }

    @Override
    public WorkManager getFlowExecutionWorkManager() {
        return this.flowExecutionWorkManager;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.getInboundEndpoint().getTransactionConfig();
    }
}

