/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.Work;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;

public abstract class TransactedPollingMessageReceiver
extends AbstractPollingMessageReceiver {
    private static final long NO_MESSAGES_SLEEP_TIME = Long.parseLong(System.getProperty("mule.vm.pollingSleepWaitTime", "50"));
    private boolean receiveMessagesInTransaction = true;
    private boolean useMultipleReceivers = true;

    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
    }

    @Deprecated
    public TransactedPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, long frequency) throws CreateException {
        this(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
    }

    public boolean isReceiveMessagesInTransaction() {
        return this.receiveMessagesInTransaction;
    }

    public void setReceiveMessagesInTransaction(boolean useTx) {
        this.receiveMessagesInTransaction = useTx;
    }

    public boolean isUseMultipleTransactedReceivers() {
        return this.useMultipleReceivers;
    }

    public void setUseMultipleTransactedReceivers(boolean useMultiple) {
        this.useMultipleReceivers = useMultiple;
    }

    @Override
    public void doStart() throws MuleException {
        this.setUseMultipleTransactedReceivers(this.connector.isCreateMultipleTransactedReceivers());
        ThreadingProfile tp = this.connector.getReceiverThreadingProfile();
        int numReceiversToStart = 1;
        if (this.isReceiveMessagesInTransaction() && this.isUseMultipleTransactedReceivers() && tp.isDoThreading()) {
            numReceiversToStart = this.connector.getNumberOfConcurrentTransactedReceivers();
        }
        for (int i = 0; i < numReceiversToStart; ++i) {
            super.doStart();
        }
    }

    @Override
    public void poll() throws Exception {
        try {
            ExecutionTemplate<MuleEvent> pt = this.createExecutionTemplate();
            if (this.isReceiveMessagesInTransaction()) {
                if (this.hasNoMessages()) {
                    if (NO_MESSAGES_SLEEP_TIME > 0L) {
                        Thread.sleep(NO_MESSAGES_SLEEP_TIME);
                    }
                    return;
                }
                ExecutionCallback<MuleEvent> cb = new ExecutionCallback<MuleEvent>(){

                    @Override
                    public MuleEvent process() throws Exception {
                        List<MuleMessage> messages = TransactedPollingMessageReceiver.this.getMessages();
                        if (messages != null && messages.size() > 0) {
                            for (MuleMessage message : messages) {
                                TransactedPollingMessageReceiver.this.processMessage(message);
                            }
                        }
                        return null;
                    }
                };
                pt.execute(cb);
            } else {
                List<MuleMessage> messages = this.getMessages();
                if (messages != null && messages.size() > 0) {
                    CountDownLatch countdown = new CountDownLatch(messages.size());
                    for (MuleMessage message : messages) {
                        try {
                            this.getWorkManager().scheduleWork(new MessageProcessorWorker(pt, countdown, message));
                        }
                        catch (Exception e) {
                            countdown.countDown();
                            throw e;
                        }
                    }
                    countdown.await();
                }
            }
        }
        catch (Exception e) {
            this.getConnector().getMuleContext().handleException(e);
        }
    }

    protected boolean hasNoMessages() {
        return false;
    }

    protected abstract List<MuleMessage> getMessages() throws Exception;

    protected abstract void processMessage(Object var1) throws Exception;

    protected class MessageProcessorWorker
    implements Work,
    ExecutionCallback<MuleEvent> {
        private final ExecutionTemplate<MuleEvent> pt;
        private final Object message;
        private final CountDownLatch latch;

        public MessageProcessorWorker(ExecutionTemplate<MuleEvent> pt, CountDownLatch latch, Object message) {
            this.pt = pt;
            this.message = message;
            this.latch = latch;
        }

        public void release() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.pt.execute(this);
            }
            catch (MessagingException e) {
            }
            catch (Exception e) {
                TransactedPollingMessageReceiver.this.connector.getMuleContext().getExceptionListener().handleException(e);
            }
            finally {
                this.latch.countDown();
            }
        }

        @Override
        public MuleEvent process() throws Exception {
            TransactedPollingMessageReceiver.this.processMessage(this.message);
            return null;
        }
    }
}

