/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtils
extends org.apache.commons.lang.math.NumberUtils {
    public static final int INTEGER_ERROR = -999999999;
    public static final long LONG_ERROR = -999999999L;
    public static final float FLOAT_ERROR = -1.0E9f;
    public static final double DOUBLE_ERROR = -9.99999999E8;

    public static long toLong(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to convert null object to long");
        }
        if (obj instanceof String) {
            return NumberUtils.toLong((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        throw new IllegalArgumentException("Unable to convert object of type: " + obj.getClass().getName() + " to long.");
    }

    public static int toInt(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to convert null object to int");
        }
        if (obj instanceof String) {
            return NumberUtils.toInt((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        throw new IllegalArgumentException("Unable to convert object of type: " + obj.getClass().getName() + " to int.");
    }

    public static float toFloat(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to convert null object to float");
        }
        if (obj instanceof String) {
            return NumberUtils.toFloat((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        throw new IllegalArgumentException("Unable to convert object of type: " + obj.getClass().getName() + " to float.");
    }

    public static double toDouble(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Unable to convert null object to double");
        }
        if (obj instanceof String) {
            return NumberUtils.toDouble((String)obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        throw new IllegalArgumentException("Unable to convert object of type: " + obj.getClass().getName() + " to double.");
    }

    public static int toInt(String str) {
        return NumberUtils.toInt((String)str, (int)-999999999);
    }

    public static long toLong(String str) {
        return NumberUtils.toLong((String)str, (long)-999999999L);
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat((String)str, (float)-1.0E9f);
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble((String)str, (double)-9.99999999E8);
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        text = text.trim();
        if (targetClass.equals(Byte.class)) {
            return (T)Byte.valueOf(text);
        }
        if (targetClass.equals(Short.class)) {
            return (T)Short.valueOf(text);
        }
        if (targetClass.equals(Integer.class)) {
            return (T)Integer.valueOf(text);
        }
        if (targetClass.equals(Long.class)) {
            return (T)Long.valueOf(text);
        }
        if (targetClass.equals(BigInteger.class)) {
            return (T)new BigInteger(text);
        }
        if (targetClass.equals(Float.class)) {
            return (T)Float.valueOf(text);
        }
        if (targetClass.equals(Double.class)) {
            return (T)Double.valueOf(text);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return (T)new BigDecimal(text);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> targetClass) throws IllegalArgumentException {
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (targetClass.equals(Byte.class)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Byte(number.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Short(number.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return (T)new Integer(number.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return (T)new Long(number.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return (T)new Float(number.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return (T)new Double(number.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }
}

