/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.PartitionableExpirableObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.util.FileUtils;
import org.mule.util.SerializationUtils;
import org.mule.util.store.AbstractPartitionedObjectStore;

public class PartitionedPersistentObjectStore<T extends Serializable>
extends AbstractPartitionedObjectStore<T>
implements MuleContextAware,
PartitionableExpirableObjectStore<T> {
    MuleContext muleContext;
    public static final String DEFAULT_OBJECT_STORE = "objectstore";
    private static final String FILE_EXTENSION = ".obj";
    private File storeDirectory;

    public PartitionedPersistentObjectStore() {
    }

    public PartitionedPersistentObjectStore(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void open(String partitionName) throws ObjectStoreException {
        this.initStoreDirectory();
        if (!this.storeDirectory.exists()) {
            this.createStoreDirectory(this.storeDirectory);
        }
    }

    @Override
    public void close(String partitionName) throws ObjectStoreException {
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean contains(Serializable key, String partitionName) throws ObjectStoreException {
        File storeFile = this.createStoreFile(key, partitionName);
        return storeFile.exists();
    }

    @Override
    public void store(Serializable key, T value, String partitionName) throws ObjectStoreException {
        boolean isNewFile;
        File outputFile = this.createStoreFile(key, partitionName);
        this.ensureStoreDirectoryExists(outputFile);
        try {
            isNewFile = outputFile.createNewFile();
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        if (!isNewFile) {
            throw new ObjectAlreadyExistsException();
        }
        this.serialize(value, outputFile);
    }

    @Override
    public T retrieve(Serializable key, String partitionName) throws ObjectStoreException {
        File file = this.createStoreFile(key, partitionName);
        return this.deserialize(file);
    }

    @Override
    public T remove(Serializable key, String partitionName) throws ObjectStoreException {
        File storeFile = this.createStoreFile(key, partitionName);
        T result = this.deserialize(storeFile);
        this.deleteStoreFile(storeFile);
        return result;
    }

    @Override
    public List<Serializable> allKeys(String partitionName) throws ObjectStoreException {
        if (this.storeDirectory == null) {
            return Collections.emptyList();
        }
        return this.collectAllKeys(partitionName);
    }

    protected List<Serializable> collectAllKeys(String partitionName) throws ObjectStoreException {
        try {
            ArrayList<Serializable> keys = new ArrayList<Serializable>();
            this.listStoredFiles(this.createStorePartition(partitionName), keys);
            return keys;
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Could not restore from %1s", this.storeDirectory.getAbsolutePath());
            throw new ObjectStoreException(CoreMessages.createStaticMessage(message));
        }
        catch (IOException e) {
            String message = String.format("Could not restore from %1s", this.storeDirectory.getAbsolutePath());
            throw new ObjectStoreException(CoreMessages.createStaticMessage(message));
        }
    }

    protected void listStoredFiles(File directory, List<Serializable> keys) throws IOException, ClassNotFoundException {
        Object[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (((File)files[i]).isDirectory()) {
                this.listStoredFiles((File)files[i], keys);
                continue;
            }
            if (!((File)files[i]).getName().endsWith(FILE_EXTENSION)) continue;
            String id = ((File)files[i]).getCanonicalPath();
            int beginIndex = this.storeDirectory.getCanonicalPath().length() + 1;
            int length = id.length() - FILE_EXTENSION.length();
            id = id.substring(beginIndex, length);
            String partition = id.substring(0, id.indexOf(File.separator));
            id = id.substring(partition.length() + 1);
            keys.add((Serializable)((Object)id));
        }
    }

    @Override
    public List<String> allPartitions() throws ObjectStoreException {
        Object[] files = this.storeDirectory.listFiles();
        if (files == null) {
            return new ArrayList<String>();
        }
        Arrays.sort(files);
        ArrayList<String> partitions = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            if (!((File)files[i]).isDirectory()) continue;
            partitions.add(((File)files[i]).getName());
        }
        return partitions;
    }

    private void initStoreDirectory() throws ObjectStoreException {
        try {
            String workingDirectory = this.muleContext.getConfiguration().getWorkingDirectory();
            String path = workingDirectory + File.separator + DEFAULT_OBJECT_STORE;
            this.storeDirectory = FileUtils.newFile(path);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected synchronized void createStoreDirectory(File directory) throws ObjectStoreException {
        if (!directory.exists() && !directory.mkdirs()) {
            Message message = CoreMessages.failedToCreate("object store directory " + directory.getAbsolutePath());
            throw new ObjectStoreException(message);
        }
    }

    protected File createStorePartition(String partitionName) throws ObjectStoreException {
        try {
            return FileUtils.newFile(this.storeDirectory, partitionName);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected File createStoreFile(Serializable key, String partitionName) throws ObjectStoreException {
        String filename = key + FILE_EXTENSION;
        String path = partitionName + File.separator + filename;
        try {
            return FileUtils.newFile(this.storeDirectory, path);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException(mre);
        }
    }

    protected void ensureStoreDirectoryExists(File outputFile) throws ObjectStoreException {
        File directory = outputFile.getParentFile();
        if (!directory.exists()) {
            this.createStoreDirectory(directory);
        }
    }

    protected void serialize(T value, File outputFile) throws ObjectStoreException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            SerializationUtils.serialize(value, (OutputStream)out);
        }
        catch (SerializationException se) {
            throw new ObjectStoreException(se);
        }
        catch (FileNotFoundException fnfe) {
            throw new ObjectStoreException(fnfe);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    this.logger.warn((Object)("error closing file " + outputFile.getAbsolutePath()));
                }
            }
        }
    }

    protected T deserialize(File file) throws ObjectStoreException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Serializable serializable = (Serializable)SerializationUtils.deserialize((InputStream)in, this.muleContext);
            return (T)serializable;
        }
        catch (SerializationException se) {
            throw new ObjectStoreException(se);
        }
        catch (FileNotFoundException fnfe) {
            throw new ObjectDoesNotExistException(fnfe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.logger.warn((Object)("error closing opened file " + file.getAbsolutePath()));
                }
            }
        }
    }

    protected void deleteStoreFile(File file) throws ObjectStoreException {
        if (file.exists()) {
            if (!file.delete()) {
                Message message = CoreMessages.createStaticMessage("Deleting " + file.getAbsolutePath() + " failed");
                throw new ObjectStoreException(message);
            }
        } else {
            throw new ObjectDoesNotExistException();
        }
    }

    @Override
    public void open() throws ObjectStoreException {
        this.initStoreDirectory();
        if (!this.storeDirectory.exists()) {
            this.createStoreDirectory(this.storeDirectory);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void expire(int entryTTL, int maxEntries) throws ObjectStoreException {
        this.expire(entryTTL, maxEntries, "DEFAULT_PARTITION");
    }

    @Override
    public void expire(int entryTTL, int maxEntries, String partitionName) throws ObjectStoreException {
        File partitionFolder = FileUtils.newFile(this.storeDirectory, partitionName);
        File[] files = partitionFolder.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int result = Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                if (result == 0) {
                    result = f1.getName().compareTo(f2.getName());
                }
                return result;
            }
        });
        int startIndex = this.trimToMaxSize(files, maxEntries);
        long now = System.currentTimeMillis();
        for (int i = startIndex; i < files.length; ++i) {
            if (!files[i].getName().endsWith(FILE_EXTENSION)) continue;
            Long lastModified = files[i].lastModified();
            if (now - lastModified < (long)entryTTL) break;
            this.deleteStoreFile(files[i]);
        }
    }

    private int trimToMaxSize(File[] files, int maxEntries) throws ObjectStoreException {
        if (maxEntries < 0) {
            return 0;
        }
        int expired = 0;
        int excess = files.length - maxEntries;
        if (excess > 0) {
            for (int i = 0; i < excess; ++i) {
                this.deleteStoreFile(files[i]);
                ++expired;
            }
        }
        return expired;
    }

    @Override
    public void disposePartition(String partitionName) throws ObjectStoreException {
        File partitionFolder = FileUtils.newFile(this.storeDirectory, partitionName);
        FileUtils.deleteQuietly((File)partitionFolder);
    }
}

