/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.MuleManifest;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.transport.http.CookieHelper;
import org.mule.transport.http.HttpConstants;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.i18n.HttpMessages;

public class MuleMessageToHttpResponse
extends AbstractMessageTransformer {
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").withLocale(Locale.US);
    private String server;

    public static String formatDate(long time) {
        return dateFormatter.print(time);
    }

    public MuleMessageToHttpResponse() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.create(HttpResponse.class));
    }

    public void initialise() throws InitialisationException {
        this.server = MuleManifest.getProductName() == null ? "Mule/SNAPSHOT" : MuleManifest.getProductName() + "/" + MuleManifest.getProductVersion();
    }

    public Object transformMessage(MuleMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        if (src instanceof NullPayload) {
            src = "";
        }
        try {
            String method;
            String connHeader;
            HttpResponse response = src instanceof HttpResponse ? (HttpResponse)src : this.createResponse(src, outputEncoding, msg);
            if (!response.containsHeader("Content-Type")) {
                response.addHeader(new Header("Content-Type", "text/plain"));
            }
            if (!response.containsHeader("Content-Length") && !response.containsHeader("Transfer-Encoding")) {
                if (response.hasBody()) {
                    long len = response.getContentLength();
                    if (len < 0L) {
                        if (response.getHttpVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                            len = msg.getPayloadAsBytes().length;
                            response.setBody(msg);
                            Header header = new Header("Content-Length", Long.toString(len));
                            response.setHeader(header);
                        } else {
                            Header header = new Header("Transfer-Encoding", "chunked");
                            response.addHeader(header);
                        }
                    } else {
                        Header header = new Header("Content-Length", Long.toString(len));
                        response.setHeader(header);
                    }
                } else {
                    Header header = new Header("Content-Length", "0");
                    response.addHeader(header);
                }
            }
            if ((connHeader = (String)msg.getOutboundProperty("Connection")) != null) {
                if (connHeader.equalsIgnoreCase("keep-alive")) {
                    response.setKeepAlive(true);
                }
                if (connHeader.equalsIgnoreCase("close")) {
                    response.setKeepAlive(false);
                }
            }
            if ("HEAD".equalsIgnoreCase(method = (String)msg.getOutboundProperty("http.method"))) {
                response.setBody((MuleMessage)null);
            }
            return response;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    protected HttpResponse createResponse(Object src, String encoding, MuleMessage msg) throws IOException, TransformerException {
        String contentType;
        HttpResponse response = new HttpResponse();
        Object tmp = msg.getOutboundProperty("http.status");
        int status = 200;
        if (tmp != null) {
            status = Integer.valueOf(tmp.toString());
        } else if (msg.getExceptionPayload() != null) {
            status = 500;
        }
        String version = (String)msg.getInboundProperty("http.version");
        if (version == null) {
            version = "HTTP/1.1";
        }
        if ((contentType = (String)msg.getInboundProperty("Content-Type")) == null) {
            contentType = (String)msg.getInvocationProperty("Content-Type");
        }
        response.setStatusLine(HttpVersion.parse((String)version), status);
        if (contentType != null) {
            response.setHeader(new Header("Content-Type", contentType));
        }
        String date = MuleMessageToHttpResponse.formatDate(System.currentTimeMillis());
        response.setHeader(new Header("Date", date));
        response.setHeader(new Header("Server", this.server));
        String etag = (String)msg.getOutboundProperty("ETag");
        if (etag != null) {
            response.setHeader(new Header("ETag", etag));
        }
        response.setFallbackCharset(encoding);
        LinkedList<String> headerNames = new LinkedList<String>();
        headerNames.addAll(HttpConstants.RESPONSE_HEADER_NAMES.values());
        headerNames.addAll(HttpConstants.GENERAL_AND_ENTITY_HEADER_NAMES.values());
        for (String headerName : headerNames) {
            if ("Set-Cookie".equals(headerName)) {
                Cookie[] arrayOfCookies;
                Object cookiesObject = msg.getInvocationProperty(headerName);
                if (cookiesObject == null) {
                    cookiesObject = msg.getOutboundProperty(headerName);
                }
                if (cookiesObject == null) {
                    cookiesObject = msg.getInboundProperty(headerName);
                }
                if (cookiesObject == null) continue;
                if (!(cookiesObject instanceof Cookie[])) {
                    response.addHeader(new Header(headerName, cookiesObject.toString()));
                    continue;
                }
                for (Cookie cookie : arrayOfCookies = CookieHelper.asArrayOfCookies(cookiesObject)) {
                    response.addHeader(new Header(headerName, CookieHelper.formatCookieForASetCookieHeader(cookie)));
                }
                continue;
            }
            Object value = msg.getInvocationProperty(headerName);
            if (value == null) {
                value = msg.getOutboundProperty(headerName);
            }
            if (value == null) continue;
            response.setHeader(new Header(headerName, value.toString()));
        }
        Map customHeaders = (Map)msg.getOutboundProperty("http.custom.headers");
        if (customHeaders != null) {
            throw new TransformerException(HttpMessages.customHeaderMapDeprecated(), (Transformer)this);
        }
        for (String headerName : msg.getOutboundPropertyNames()) {
            Object v;
            if (response.getFirstHeader(headerName) != null || (v = msg.getOutboundProperty(headerName)) == null) continue;
            if (headerName.startsWith("MULE_")) {
                headerName = "X-" + headerName;
            }
            response.setHeader(new Header(headerName, v.toString()));
        }
        if (msg.getCorrelationId() != null) {
            response.setHeader(new Header("X-MULE_CORRELATION_ID", msg.getCorrelationId()));
            response.setHeader(new Header("X-MULE_CORRELATION_GROUP_SIZE", String.valueOf(msg.getCorrelationGroupSize())));
            response.setHeader(new Header("X-MULE_CORRELATION_SEQUENCE", String.valueOf(msg.getCorrelationSequence())));
        }
        if (msg.getReplyTo() != null) {
            response.setHeader(new Header("X-MULE_REPLYTO", msg.getReplyTo().toString()));
        }
        try {
            response.setBody(msg);
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return response;
    }

    public boolean isAcceptNull() {
        return true;
    }
}

